export interface User {
    id: string;
    email: string;
    password: string;
    name: string;
    role: 'ADMIN' | 'USER';
    isActive: boolean;
    createdAt: string;
    updatedAt: string;
    lastLoginAt?: string;
}

export interface CreateUserRequest {
    email: string;
    password: string;
    name: string;
    role?: 'ADMIN' | 'USER';
}

export interface LoginRequest {
    email: string;
    password: string;
}

export interface AuthResponse {
    user: Omit<User, 'password'>;
    token: string;
}

export interface ResetPasswordRequest {
    email: string;
}

export interface UpdatePasswordRequest {
    token: string;
    newPassword: string;
}

export interface AuthState {
    user: Omit<User, 'password'> | null;
    isAuthenticated: boolean;
    isLoading: boolean;
    error: string | null;
}

export interface AuthActions {
    login: (email: string, password: string) => Promise<void>;
    register: (userData: CreateUserRequest) => Promise<void>;
    logout: () => void;
    forgotPassword: (email: string) => Promise<void>;
    resetPassword: (token: string, newPassword: string) => Promise<void>;
    clearError: () => void;
    checkAuth: () => Promise<void>;
}
