export type TaskRelatedToType = 'customer' | 'domain' | 'project' | 'quote' | 'general';

export type TaskStatus = 'pending' | 'in_progress' | 'completed' | 'cancelled' | 'on_hold';

export type TaskPriority = 'low' | 'medium' | 'high' | 'urgent';

export interface Task {
    id: number;
    title: string;
    description?: string;
    customer_id?: string;
    domain_id?: string;
    project_id?: string;
    quote_id?: string;
    reminder_id?: string;
    related_to_type?: TaskRelatedToType;
    status: TaskStatus;
    priority: TaskPriority;
    assigned_to?: string;
    created_by?: string;
    start_date?: string;
    due_date?: string;
    completed_date?: string;
    estimated_hours?: number;
    actual_hours?: number;
    progress: number; // 0-100
    category?: string;
    tags?: string; // JSON string of array
    recurring?: 0 | 1;
    recurring_pattern?: 'daily' | 'weekly' | 'monthly' | 'quarterly' | 'yearly';
    parent_task_id?: number;
    auto_created?: 0 | 1;
    notes?: string;
    created_date: string;
    last_activity: string;
    updated_at: string;
}

export interface TaskWithDetails extends Task {
    customer_name?: string;
    customer_company?: string;
    customer_email?: string;
    customer_phone?: string;
    customer_status?: string;
    domain_name?: string;
    domain_status?: string;
    project_title?: string;
    project_status?: string;
    project_budget?: number;
    quote_title?: string;
    quote_amount?: number;
    quote_status?: string;
    urgency_status?: 'overdue' | 'today' | 'this_week' | 'future';
    subtasks_count?: number;
    subtasks_completed?: number;
}


