export interface EventTag {
    id: string;
    name: string;
    color: string;
    description?: string;
    created_date?: string;
    updated_at?: string;
}

export interface EventTagLink {
    id: number;
    event_id: number;
    tag_id: number;
    created_date?: string;
}

export interface EventWithTags {
    id: number;
    title: string;
    description?: string;
    start_datetime: string;
    end_datetime?: string;
    location?: string;
    customer_id?: string;
    domain_id?: string;
    project_id?: string;
    quote_id?: string;
    event_type: string;
    status: string;
    attendees?: string;
    reminder_minutes: number;
    created_by?: string;
    created_date?: string;
    updated_at?: string;
    tags?: EventTag[];
}

export interface CreateEventTagData {
    name: string;
    color: string;
    description?: string;
}

export interface UpdateEventTagData {
    name?: string;
    color?: string;
    description?: string;
}

// צבעים מוכנים לתגיות
export const PREDEFINED_COLORS = [
    { name: 'כחול', value: '#3B82F6' },
    { name: 'ירוק', value: '#10B981' },
    { name: 'צהוב', value: '#F59E0B' },
    { name: 'אדום', value: '#EF4444' },
    { name: 'סגול', value: '#8B5CF6' },
    { name: 'ורוד', value: '#EC4899' },
    { name: 'טורקיז', value: '#14B8A6' },
    { name: 'אפור', value: '#6B7280' },
    { name: 'שחור', value: '#1F2937' },
    { name: 'כתום', value: '#F97316' },
    { name: 'ליים', value: '#84CC16' },
    { name: 'אינדיגו', value: '#6366F1' }
];
