export interface Phone {
    id: string;
    phone: string;
    domain: string; // שדה חדש
    website: string;
    owner: string;
    email: string;
    package: string;
    amount: number;
    status: 'paid' | 'pending' | 'overdue' | 'free' | 'paused' | 'delete_backup' | 'delete_no_backup' | 'renewal';
    priority: 'high' | 'medium' | 'low' | 'to-delete' | 'to-check';
    startDate: string;
    nextPayment: string;
    lastUpdate: string;
    createdAt: string;
    updatedAt: string;
    notes?: string; // שדה הערות - אופציונלי
}

export interface StatsCard {
    id: string;
    title: string;
    value: number;
    icon: string;
    color: 'red' | 'yellow' | 'green' | 'blue';
}

export interface Alert {
    id: string;
    type: 'warning' | 'error';
    title: string;
    message: string;
    count: number;
}

export interface FilterOptions {
    search: string;
    priority: string;
    status: string;
    showEntries: number;
    nextPaymentFrom?: string; // YYYY-MM-DD
    nextPaymentTo?: string;   // YYYY-MM-DD
}