/**
 * Types for Notes Module
 * מודול פתקים - הגדרות TypeScript
 */

export interface List {
    id: string;
    name: string;
    color?: string;
    icon?: string;  // emoji או שם אייקון
    sortOrder: number;
    createdAt: string;
    updatedAt: string;
}

export interface Subtask {
    id: string;
    title: string;
    done: boolean;
}

export interface Attachment {
    id: string;
    name: string;
    type: string;  // MIME type
    size: number;  // bytes
    url: string;
    uploadedAt: string;
}

export type RecurrenceType = 'none' | 'daily' | 'weekly' | 'monthly' | 'yearly';

export interface Note {
    id: string;
    listId: string | null;
    title: string;
    description?: string;
    done: boolean;
    important: boolean;
    flagged: boolean;
    dueDate?: string | null;
    reminderDate?: string | null;  // תאריך תזכורת
    reminderTime?: string | null;  // שעת תזכורת (HH:mm)
    reminderRecurrence?: RecurrenceType;  // האם התזכורת חוזרת
    createdAt: string;
    updatedAt: string;
    subtasks?: Subtask[];
    tags?: string[];
    attachments?: Attachment[];  // קבצים מצורפים
}

export type SmartListType = 'important' | 'planned' | 'all' | 'completed' | 'flagged' | 'today';

export interface SmartList {
    id: SmartListType;
    name: string;
    icon: string;
    color: string;
    filter: (notes: Note[]) => Note[];
}

export type FilterType = 'all' | 'open' | 'completed';
export type SortType = 'date' | 'importance' | 'alphabetical' | 'dueDate';

export interface NotesFilters {
    type: FilterType;
    sortBy: SortType;
    searchQuery: string;
}

