export type EventType = 'meeting' | 'call' | 'presentation' | 'webinar' | 'deadline' | 'reminder' | 'other';
export type EventStatus = 'scheduled' | 'in_progress' | 'completed' | 'cancelled' | 'postponed';

export interface Event {
    id: number;
    title: string;
    description?: string;
    start_datetime: string;
    end_datetime?: string;
    location?: string;
    customer_id?: string;
    domain_id?: string;
    project_id?: string;
    quote_id?: string;
    event_type: EventType;
    status: EventStatus;
    attendees?: string; // JSON array
    reminder_minutes: number;
    created_by?: string;
    created_date?: string;
    updated_at?: string;
}

export interface EventWithDetails extends Event {
    customer_name?: string;
    customer_company?: string;
    customer_email?: string;
    customer_phone?: string;
    domain_name?: string;
    project_title?: string;
    quote_title?: string;
    related_tasks?: Task[];
}

export interface Task {
    id: number;
    title: string;
    description?: string;
    customer_id: string;
    domain_id?: string;
    project_id?: string;
    event_id?: number;
    status: 'pending' | 'in_progress' | 'completed' | 'cancelled' | 'on_hold';
    priority: 'low' | 'medium' | 'high' | 'urgent';
    due_date?: string;
    progress: number;
    category?: string;
    event_title?: string;
    event_start?: string;
    event_end?: string;
    event_type?: string;
}

export interface CreateEventData {
    title: string;
    description?: string;
    start_datetime: string;
    end_datetime?: string;
    location?: string;
    customer_id?: string;
    domain_id?: string;
    project_id?: string;
    quote_id?: string;
    event_type?: EventType;
    status?: EventStatus;
    attendees?: string[];
    reminder_minutes?: number;
    created_by?: string;
}

export interface EventTaskLink {
    task_id: number;
    event_id: number;
    relationship_type: 'preparation' | 'followup' | 'discussion' | 'related';
}
