export interface EmailTemplate {
    id: string;
    name: string;
    subject: string;
    body: string;
    variables: string[];
    isActive: boolean;
    createdAt: Date;
    updatedAt: Date;
}

export interface OverdueCustomer {
    id: string;
    name: string;
    email: string;
    companyName?: string;
    domain: string;
    amount: number;
    daysOverdue: number;
    lastPaymentDate: Date;
    nextPaymentDate: Date;
    paymentLink?: string;
    selected: boolean;
}

export interface EmailLog {
    id: string;
    templateId: string;
    customerId: string;
    customerEmail: string;
    subject: string;
    body: string;
    sentAt: Date;
    status: 'sent' | 'failed' | 'bounced';
    openedAt?: Date;
    clickedAt?: Date;
    error?: string;
}

export interface EmailSendRequest {
    type: 'single' | 'bulk';
    data: {
        to?: string;
        subject?: string;
        html?: string;
        text?: string;
        recipients?: OverdueCustomer[];
        templateId?: string;
        templateSubject?: string;
        templateBody?: string;
    };
}


