export interface Phone {
    id: string;
    phone: string;
    website: string;
    owner: string;
    email: string;
    package: string;
    amount: number;
    status: 'paid' | 'pending' | 'overdue';
    priority: 'high' | 'medium' | 'low';
    nextPayment: string;
    lastUpdate: string;
    createdAt: string;
    updatedAt: string;
}

export interface StatsCard {
    id: string;
    title: string;
    value: number;
    icon: string;
    color: 'red' | 'yellow' | 'green' | 'blue';
}

export interface Alert {
    id: string;
    type: 'warning' | 'error';
    title: string;
    message: string;
    count: number;
}

export interface FilterOptions {
    search: string;
    priority: string;
    status: string;
    showEntries: number;
}