export interface Customer {
    id: string;
    name: string;
    email: string;
    phone?: string;
    company?: string;
    status: 'active' | 'inactive' | 'lead';
    stage: 'quote' | 'project' | 'follow_up' | 'closed';
    assigned_sales_rep?: string;
    value: number;
    notes?: string;
    created_date: string;
    last_activity: string;
    updated_at: string;
}

export interface CustomerForm {
    name: string;
    email: string;
    phone?: string;
    company?: string;
    status: 'active' | 'inactive' | 'lead';
    stage: 'quote' | 'project' | 'follow_up' | 'closed';
    assigned_sales_rep?: string;
    value: number;
    notes?: string;
}

export interface Quote {
    id: string;
    customer_id: string;
    title: string;
    amount: number;
    status: 'pending' | 'sent' | 'approved' | 'rejected';
    created_date: string;
    valid_until?: string;
    notes?: string;
}

export interface Project {
    id: string;
    customer_id: string;
    title: string;
    description?: string;
    status: 'planning' | 'in_progress' | 'completed' | 'on_hold';
    start_date?: string;
    end_date?: string;
    budget?: number;
    progress: number;
    created_date: string;
    updated_at: string;
}

export interface DashboardStats {
    contactsLastWeek: number;
    contactsToday: number;
    salesReps: number;
    totalCustomers: number;
    latePayments: number;
    latePaymentsPercent: number;
    unpaidInvoices: number;
    unpaidInvoicesPercent: number;
    openQuotes: number;
    wonQuotes: number;
    newQuoteRequests: number;
    updatedQuoteRequests: number;
    totalProjects: number;
    openProjects: number;
    completedProjects: number;
    inProgressProjects: number;
    openOpportunities: number;
    openOpportunitiesPercent: number;
}
