export interface Attachment {
    id: number;
    entity_type: 'customer' | 'task' | 'event' | 'project';
    entity_id: number;
    file_name: string;
    original_name: string;
    file_type: string;
    file_size: number;
    mime_type: string;
    file_path: string;
    is_voice_recording: boolean;
    duration?: number; // For voice recordings, in seconds
    created_at: string;
    created_by?: string;
    notes?: string;
}

export interface CreateAttachmentDTO {
    entity_type: 'customer' | 'task' | 'event' | 'project';
    entity_id: number;
    file: File;
    is_voice_recording?: boolean;
    duration?: number;
    notes?: string;
}

export interface AttachmentUploadResponse {
    success: boolean;
    attachment?: Attachment;
    error?: string;
}


