import { create } from 'zustand';

interface AlertState {
    dismissedAlerts: string[];
    dismissAlert: (alertId: string) => void;
    isAlertDismissed: (alertId: string) => boolean;
}

export const useAlertStore = create<AlertState>((set, get) => ({
    dismissedAlerts: [],

    dismissAlert: (alertId: string) => {
        set((state) => ({
            dismissedAlerts: [...state.dismissedAlerts, alertId]
        }));
    },

    isAlertDismissed: (alertId: string) => {
        return get().dismissedAlerts.includes(alertId);
    }
}));
