import { EmailTemplate } from '@/types/email';

export const defaultTemplate: EmailTemplate = {
    id: '1',
    name: 'תזכורת תשלום סטנדרטית',
    subject: 'תזכורת תשלום אחסון עבור {domain}',
    body: `
    <div dir="rtl" style="font-family: Arial, sans-serif; max-width: 600px; margin: 0 auto; padding: 20px; background-color: #f9fafb;">
      <div style="background-color: white; border-radius: 8px; padding: 30px; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
        <h2 style="color: #1f2937; margin-bottom: 20px;">שלום {customerName},</h2>

        <p style="color: #4b5563; line-height: 1.6; margin-bottom: 15px;">
          זוהי תזכורת ידידותית שהתשלום עבור שירות האחסון של <strong>{domain}</strong> באיחור של <strong>{daysOverdue} ימים</strong>.
        </p>
        
        <div style="background-color: #fef3c7; border-right: 4px solid #f59e0b; padding: 15px; margin: 20px 0; border-radius: 4px;">
          <h3 style="color: #92400e; margin: 0 0 10px 0;">פרטי התשלום:</h3>
          <ul style="color: #92400e; margin: 0; padding-right: 20px;">
            <li>סכום לתשלום: <strong>₪{amount}</strong></li>
            <li>דומיין: <strong>{domain}</strong></li>
            <li>חבילה: <strong>{packageName}</strong></li>
          </ul>
        </div>
        
        <div style="text-align: center; margin: 30px 0;">
          <a href="{paymentLink}" style="background-color: #2563eb; color: white; padding: 12px 30px; text-decoration: none; border-radius: 6px; display: inline-block; font-weight: bold;">
            לתשלום מיידי
          </a>
        </div>
        
        <p style="color: #6b7280; font-size: 14px; margin-top: 20px;">
          במידה ותשלום בוצע, אנא התעלם מהודעה זו.
        </p>
        
        <hr style="border: none; border-top: 1px solid #e5e7eb; margin: 30px 0;" />
        
        <p style="color: #6b7280; font-size: 14px; margin: 0;">
          בברכה,<br/>
          <strong>צוות התמיכה</strong><br/>
          {supportEmail}<br/>
          {companyName}
        </p>
      </div>
      
      <p style="text-align: center; color: #9ca3af; font-size: 12px; margin-top: 20px;">
        © 2025 {companyName}. כל הזכויות שמורות.
      </p>
    </div>
  `,
    variables: [
        'customerName',
        'domain',
        'amount',
        'daysOverdue',
        'packageName',
        'paymentLink',
        'supportEmail',
        'companyName',
    ],
    isActive: true,
    createdAt: new Date(),
    updatedAt: new Date(),
};

export async function getEmailTemplates(): Promise<EmailTemplate[]> {
    // In production, fetch from database
    return [defaultTemplate];
}

export async function getTemplateById(id: string): Promise<EmailTemplate | null> {
    const templates = await getEmailTemplates();
    return templates.find(t => t.id === id) || null;
}
