import nodemailer from 'nodemailer';

const port = parseInt(process.env.SMTP_PORT || '587');
const transporter = nodemailer.createTransport({
    host: process.env.SMTP_HOST || 'mail.tsm.co.il',
    port: port,
    secure: port === 465, // Use SSL for port 465
    auth: {
        user: process.env.SMTP_USER || 'sales@tsm.co.il',
        pass: process.env.SMTP_PASSWORD || '3qewradsf@',
    },
    // Don't force TLS - let the server decide
    connectionTimeout: 15000, // 15 seconds
    greetingTimeout: 15000, // 15 seconds
    socketTimeout: 15000 // 15 seconds
});

// Verify connection
transporter.verify((error, success) => {
    if (error) {
        console.log('❌ SMTP Connection Error:', error);
    } else {
        console.log('✅ SMTP Server ready');
    }
});

export async function sendEmail({
    to,
    subject,
    html,
    text,
}: {
    to: string;
    subject: string;
    html: string;
    text?: string;
}) {
    try {
        const info = await transporter.sendMail({
            from: `"${process.env.SMTP_FROM_NAME || 'TSM Company'}" <${process.env.SMTP_FROM_EMAIL || 'sales@tsm.co.il'}>`,
            to,
            subject,
            text: text || '',
            html,
        });
        return { success: true, messageId: info.messageId };
    } catch (error) {
        console.error('❌ Email Error:', error);
        return { success: false, error: error instanceof Error ? error.message : 'Unknown error' };
    }
}

export async function sendBulkEmails(
    emails: Array<{ to: string; subject: string; html: string; text?: string }>
) {
    const results = [];
    for (const email of emails) {
        await new Promise(resolve => setTimeout(resolve, 500)); // Rate limiting
        const result = await sendEmail(email);
        results.push({ to: email.to, ...result });
    }
    return results;
}

export function populateTemplate(template: string, variables: Record<string, string>): string {
    let populated = template;
    Object.entries(variables).forEach(([key, value]) => {
        const regex = new RegExp(`{${key}}`, 'g');
        populated = populated.replace(regex, value);
    });
    return populated;
}

export async function testEmailConnection() {
    try {
        await transporter.verify();
        return { success: true, message: 'SMTP connection successful' };
    } catch (error) {
        return { success: false, error: error instanceof Error ? error.message : 'Unknown error' };
    }
}
