import sqlite3 from 'sqlite3';
import { Database } from 'sqlite3';
import path from 'path';

let db: Database | null = null;

export const openDB = (): Promise<Database> => {
  return new Promise((resolve, reject) => {
    if (db) {
      resolve(db);
      return;
    }

    // Use comprehensive.db as the main database
    const dbPath = path.join(process.cwd(), 'comprehensive.db');
    const database = new sqlite3.Database(dbPath, (err) => {
      if (err) {
        console.error('Error opening database:', err);
        reject(err);
      } else {
        console.log('Connected to SQLite database at:', dbPath);
        db = database;
        resolve(database);
      }
    });
  });
};

export const closeDB = (): Promise<void> => {
  return new Promise((resolve, reject) => {
    if (db) {
      db.close((err) => {
        if (err) {
          console.error('Error closing database:', err);
          reject(err);
        } else {
          console.log('Database connection closed');
          db = null;
          resolve();
        }
      });
    } else {
      resolve();
    }
  });
};
