import { Phone, StatsCard, Alert } from '@/types/phone';

export const statsCards: StatsCard[] = [
    {
        id: 'overdue',
        title: 'פיגור',
        value: 27,
        icon: 'triangle-warning',
        color: 'red'
    },
    {
        id: 'pending',
        title: 'ממתין',
        value: 28,
        icon: 'clock',
        color: 'yellow'
    },
    {
        id: 'paid',
        title: 'שולם',
        value: 32,
        icon: 'check',
        color: 'green'
    },
    {
        id: 'total',
        title: 'סה"כ דומיינים',
        value: 87,
        icon: 'globe',
        color: 'blue'
    }
];

export const alerts: Alert[] = [
    {
        id: 'payments-pending',
        type: 'warning',
        title: 'תשלומים ממתינים',
        message: '28 פלאפונים ממתינים לתשלום',
        count: 28
    },
    {
        id: 'overdue-payments',
        type: 'error',
        title: 'פיגורים בתשלום',
        message: '27 פלאפונים בפיגור - נדרש טיפול דחוף',
        count: 27
    }
];

export const phones: Phone[] = [
    {
        id: '1',
        phone: '050-1234567',
        domain: '4tgroup.co.il',
        website: 'https://4tgroup.co.il',
        owner: 'משה כהן',
        email: 'moshe@4tgroup.co.il',
        package: 'Linux Mini Professionals',
        amount: 299.99,
        status: 'paid',
        priority: 'medium',
        nextPayment: '2025-02-12',
        lastUpdate: '2024-12-15',
        createdAt: '2024-12-15T10:00:00.000Z',
        updatedAt: '2024-12-15T10:00:00.000Z',
        notes: 'לקוח ותיק, תמיד משלם בזמן'
    },
    {
        id: '2',
        phone: '050-9876543',
        domain: 'example.co.il',
        website: 'https://example.co.il',
        owner: 'חברת אורל',
        email: 'info@example.co.il',
        package: 'Linux Mini Professionals',
        amount: 199.99,
        status: 'pending',
        priority: 'to-check',
        nextPayment: '2025-01-20',
        lastUpdate: '2024-12-10',
        createdAt: '2024-12-10T10:00:00.000Z',
        updatedAt: '2024-12-10T10:00:00.000Z',
        notes: 'חברה גדולה, צריך לבדוק את התשלום'
    },
    {
        id: '3',
        phone: '050-5555555',
        domain: 'testphone.co.il',
        website: 'https://testphone.co.il',
        owner: 'דוד לוי',
        email: 'david@testphone.co.il',
        package: 'Linux Mini Professionals',
        amount: 399.99,
        status: 'overdue',
        priority: 'to-delete',
        nextPayment: '2024-11-30',
        lastUpdate: '2024-11-15',
        createdAt: '2024-11-15T10:00:00.000Z',
        updatedAt: '2024-11-15T10:00:00.000Z',
        notes: 'לקוח בעייתי, לא משלם בזמן'
    },
    {
        id: '4',
        phone: '050-1111111',
        domain: 'free-example.co.il',
        website: 'https://free-example.co.il',
        owner: 'שרה גולד',
        email: 'sara@free-example.co.il',
        package: 'Linux Mini Professionals',
        amount: 0,
        status: 'free',
        priority: 'low',
        nextPayment: '2025-12-31',
        lastUpdate: '2024-12-20',
        createdAt: '2024-12-20T10:00:00.000Z',
        updatedAt: '2024-12-20T10:00:00.000Z',
        notes: 'דומיין חינם - לקוח VIP'
    }
];