'use client';

import { AlertTriangle, Trash2 } from 'lucide-react';
import Modal from './Modal';

interface ConfirmModalProps {
    isOpen: boolean;
    onClose: () => void;
    onConfirm: () => void;
    title: string;
    message: string;
    confirmText?: string;
    cancelText?: string;
    type?: 'danger' | 'warning' | 'info';
    isLoading?: boolean;
}

const typeConfig = {
    danger: {
        icon: Trash2,
        iconColor: 'text-red-600',
        iconBg: 'bg-red-100',
        confirmButton: 'bg-red-600 hover:bg-red-700 focus:ring-red-500',
    },
    warning: {
        icon: AlertTriangle,
        iconColor: 'text-yellow-600',
        iconBg: 'bg-yellow-100',
        confirmButton: 'bg-yellow-600 hover:bg-yellow-700 focus:ring-yellow-500',
    },
    info: {
        icon: AlertTriangle,
        iconColor: 'text-blue-600',
        iconBg: 'bg-blue-100',
        confirmButton: 'bg-blue-600 hover:bg-blue-700 focus:ring-blue-500',
    },
};

export default function ConfirmModal({
    isOpen,
    onClose,
    onConfirm,
    title,
    message,
    confirmText = 'אישור',
    cancelText = 'ביטול',
    type = 'danger',
    isLoading = false,
}: ConfirmModalProps) {
    const config = typeConfig[type];
    const IconComponent = config.icon;

    const handleConfirm = () => {
        onConfirm();
    };

    return (
        <Modal
            isOpen={isOpen}
            onClose={onClose}
            title={title}
            size="sm"
            showCloseButton={!isLoading}
        >
            <div className="p-6">
                <div className="flex items-start">
                    <div className={`flex-shrink-0 w-10 h-10 rounded-full ${config.iconBg} flex items-center justify-center ml-3`}>
                        <IconComponent className={`w-5 h-5 ${config.iconColor}`} />
                    </div>
                    <div className="flex-1">
                        <h3 className="text-lg font-medium text-gray-900 mb-2">{title}</h3>
                        <p className="text-sm text-gray-500 mb-6">{message}</p>

                        <div className="flex items-center justify-end space-x-3 space-x-reverse">
                            <button
                                type="button"
                                onClick={onClose}
                                disabled={isLoading}
                                className="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-md hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500 disabled:opacity-50 disabled:cursor-not-allowed"
                            >
                                {cancelText}
                            </button>
                            <button
                                type="button"
                                onClick={handleConfirm}
                                disabled={isLoading}
                                className={`px-4 py-2 text-sm font-medium text-white border border-transparent rounded-md focus:outline-none focus:ring-2 focus:ring-offset-2 ${config.confirmButton} disabled:opacity-50 disabled:cursor-not-allowed`}
                            >
                                {isLoading ? 'מעבד...' : confirmText}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </Modal>
    );
}
