'use client';

import { useState, useEffect } from 'react';
import { usePathname } from 'next/navigation';
import {
    Monitor,
    Anchor,
    Calendar,
    Briefcase,
    Puzzle,
    Check,
    Clipboard,
    Users,
    CreditCard,
    ShoppingCart,
    MessageSquare,
    Bell,
    Ticket,
    ArrowRight,
    Clock,
    ChevronDown,
    ChevronRight,
    Mail,
    BarChart3,
    FileText,
    Send,
    History,
    Settings,
    TestTube,
    MailOpen,
    StickyNote
} from 'lucide-react';

const menuItems = [
    { id: 'dashboard', label: 'לוח בקרה', icon: Monitor, href: '/' },
    { id: 'phones', label: 'ניהול דומיינים', icon: Anchor, href: '/' },
    { id: 'customers', label: 'לקוחות', icon: Briefcase, href: '/customers' },
    {
        id: 'emails',
        label: 'מיילים',
        icon: Mail,
        href: '/emails',
        subItems: [
            { id: 'overview', label: 'סקירה כללית', icon: BarChart3, href: '/emails/overview' },
            { id: 'templates', label: 'ניהול תבניות', icon: FileText, href: '/emails/templates' },
            { id: 'accounts', label: 'ניהול כתובות', icon: MailOpen, href: '/emails/accounts' },
            { id: 'send', label: 'שליחה', icon: Send, href: '/emails' },
            { id: 'history', label: 'היסטוריית שליחות', icon: History, href: '/emails/history' },
            { id: 'settings', label: 'הגדרות SMTP', icon: Settings, href: '/emails/settings' },
            { id: 'test', label: 'בדיקת חיבור', icon: TestTube, href: '/emails/test' },
        ]
    },
    { id: 'comprehensive', label: 'דשבורד מקיף', icon: Users, href: '/comprehensive' },
    { id: 'dashboard-integrated', label: 'דשבורד משולב', icon: Monitor, href: '/dashboard-integrated' },
    { id: 'calendar', label: 'לוח שנה', icon: Calendar, href: '/calendar' },
    { id: 'events', label: 'אירועים', icon: Calendar, href: '/events' },
    { id: 'projects', label: 'פרויקטים', icon: Puzzle, href: '/projects' },
    { id: 'tasks', label: 'משימות', icon: Check, href: '/tasks' },
    { id: 'notes', label: 'פתקים', icon: StickyNote, href: '/notes' },
    { id: 'task-list', label: 'רשימת משימות', icon: Clipboard, href: '#' },
    { id: 'leads', label: 'לקוחות פוטנציאליים', icon: Users, href: '#' },
    { id: 'subscriptions', label: 'מנויים', icon: CreditCard, href: '#' },
    { id: 'sales', label: 'מכירות', icon: ShoppingCart, href: '#' },
    { id: 'opportunities', label: 'הזדמנויות', icon: Anchor, href: '#' },
    { id: 'messages', label: 'הודעות', icon: Bell, href: '#' },
    { id: 'tickets', label: 'כרטיסים', icon: Ticket, href: '#' },
    { id: 'expenses', label: 'הוצאות', icon: ArrowRight, href: '#' },
    { id: 'reports', label: 'דוחות', icon: Clock, href: '#' },
];

export default function Sidebar() {
    const pathname = usePathname();
    const [openMenus, setOpenMenus] = useState<string[]>([]);

    // פתח את תפריט המיילים אוטומטית אם אנחנו בדף מיילים
    useEffect(() => {
        if (pathname.startsWith('/emails')) {
            setOpenMenus(['emails']);
        } else {
            setOpenMenus([]); // סגור את כל התפריטים אם לא בדף מיילים
        }
    }, [pathname]); // כל שינוי בנתיב יעדכן את התפריט

    const toggleMenu = (menuId: string) => {
        setOpenMenus(prev =>
            prev.includes(menuId)
                ? prev.filter(id => id !== menuId)
                : [...prev, menuId]
        );
    };

    return (
        <div className="w-64 bg-gradient-to-b from-slate-800 to-slate-900 shadow-2xl h-full flex flex-col">
            {/* Header */}
            <div className="p-6 border-b border-slate-700">
                <div className="flex items-center">
                    <div className="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center ml-3 shadow-lg">
                        <span className="text-white font-bold text-lg">#</span>
                    </div>
                    <div>
                        <h2 className="text-lg font-bold text-white">מערכת CRM</h2>
                    </div>
                </div>
            </div>

            {/* Navigation Menu */}
            <nav className="mt-8 overflow-y-auto flex-1">
                <div className="px-4">
                    {menuItems.map((item) => {
                        const hasSubMenu = 'subItems' in item && item.subItems && item.subItems.length > 0;
                        const isMenuOpen = openMenus.includes(item.id);
                        const isActive = pathname === item.href ||
                            (item.href === '/' && pathname === '/') ||
                            (item.href !== '/' && pathname.startsWith(item.href));

                        return (
                            <div key={item.id} className="mb-2">
                                {/* Main Menu Item */}
                                {hasSubMenu ? (
                                    <button
                                        onClick={() => toggleMenu(item.id)}
                                        className={`group flex items-center w-full px-4 py-3 text-sm font-medium rounded-xl transition-all duration-300 ${isActive
                                            ? 'bg-blue-600 text-white shadow-lg'
                                            : 'text-slate-300 hover:bg-slate-700 hover:text-white'
                                            }`}
                                    >
                                        <item.icon
                                            className={`w-5 h-5 ml-3 ${isActive ? 'text-white' : 'text-slate-400 group-hover:text-white'}`}
                                        />
                                        <span className="flex-1">{item.label}</span>
                                        {isMenuOpen ? (
                                            <ChevronDown className="w-4 h-4" />
                                        ) : (
                                            <ChevronRight className="w-4 h-4" />
                                        )}
                                    </button>
                                ) : (
                                    <a
                                        href={item.href}
                                        className={`group flex items-center px-4 py-3 text-sm font-medium rounded-xl transition-all duration-300 ${isActive
                                            ? 'bg-blue-600 text-white shadow-lg transform scale-105'
                                            : 'text-slate-300 hover:bg-slate-700 hover:text-white hover:transform hover:scale-105'
                                            }`}
                                    >
                                        <item.icon
                                            className={`w-5 h-5 ml-3 ${isActive ? 'text-white' : 'text-slate-400 group-hover:text-white'}`}
                                        />
                                        <span className="flex-1">{item.label}</span>
                                    </a>
                                )}

                                {/* Sub Menu Items */}
                                {hasSubMenu && isMenuOpen && (
                                    <div className="mt-1 mr-4 space-y-1">
                                        {item.subItems!.map((subItem) => {
                                            const isSubActive = pathname === subItem.href;
                                            return (
                                                <a
                                                    key={subItem.id}
                                                    href={subItem.href}
                                                    className={`group flex items-center px-4 py-2 text-sm rounded-lg transition-all duration-200 ${isSubActive
                                                        ? 'bg-blue-500 text-white shadow-md'
                                                        : 'text-slate-400 hover:bg-slate-700 hover:text-white'
                                                        }`}
                                                >
                                                    <subItem.icon className="w-4 h-4 ml-3" />
                                                    <span>{subItem.label}</span>
                                                </a>
                                            );
                                        })}
                                    </div>
                                )}
                            </div>
                        );
                    })}
                </div>
            </nav>

            {/* Bottom Section */}
            <div className="mt-auto p-4">
                <div className="bg-slate-700 rounded-lg p-3">
                    <div className="flex items-center">
                        <div className="w-8 h-8 bg-slate-600 rounded-full flex items-center justify-center ml-3">
                            <span className="text-slate-300 text-xs font-bold">N</span>
                        </div>
                        <div>
                            <p className="text-xs text-slate-300">פרופיל</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
}
