'use client';

import { useState, useEffect } from 'react';
import {
    Mail,
    Bell,
    Clock,
    Globe,
    Plus,
    Search,
    Monitor,
    Briefcase,
    Grid,
    Check,
    Menu,
    Upload,
    Download,
    LogOut,
    User,
    HardDrive
} from 'lucide-react';
import { useUIStore } from '@/src/store/uiStore';
import { useRouter } from 'next/navigation';
import { Button } from '@/src/components/ui/button';
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuSeparator, DropdownMenuTrigger } from '@/src/components/ui/dropdown-menu';

export default function Header() {
    const router = useRouter();
    const [user, setUser] = useState<any>(null);

    useEffect(() => {
        // קבלת המשתמש מה-API
        fetch('/api/auth/me')
            .then(res => res.json())
            .then(data => {
                if (data.user) {
                    setUser(data.user);
                }
            })
            .catch(err => console.error('Error fetching user:', err));
    }, []);

    const handleLogout = async () => {
        await fetch('/api/auth/logout', { method: 'POST' });
        router.push('/login');
    };

    return (
        <header className="bg-white shadow-lg border-b border-gray-200">
            <div className="px-8 py-4">
                <div className="flex items-center justify-between">
                    {/* Left Side - User */}
                    <div className="flex items-center space-x-4 space-x-reverse">
                        {user && (
                            <DropdownMenu>
                                <DropdownMenuTrigger asChild>
                                    <Button variant="ghost" className="flex items-center space-x-3 space-x-reverse hover:bg-gray-100">
                                        <div className="w-8 h-8 bg-blue-100 rounded-full flex items-center justify-center">
                                            <User className="w-4 h-4 text-blue-600" />
                                        </div>
                                        <span className="text-sm font-medium text-gray-900">{user.name}</span>
                                    </Button>
                                </DropdownMenuTrigger>
                                <DropdownMenuContent align="end" className="w-56 z-50 relative">
                                    <DropdownMenuItem disabled>
                                        <div className="flex flex-col">
                                            <span className="font-medium">{user.name}</span>
                                            <span className="text-xs text-gray-500">{user.email}</span>
                                            <span className="text-xs text-blue-600">{user.role}</span>
                                        </div>
                                    </DropdownMenuItem>
                                    <DropdownMenuSeparator />
                                    <DropdownMenuItem onClick={handleLogout} className="text-red-600">
                                        <LogOut className="w-4 h-4 ml-2" />
                                        התנתק
                                    </DropdownMenuItem>
                                </DropdownMenuContent>
                            </DropdownMenu>
                        )}
                    </div>

                    {/* Center - Action Icons */}
                    <div className="flex items-center space-x-2 space-x-reverse">
                        <button
                            className="p-3 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg transition-all duration-300"
                            title="חיפוש"
                            aria-label="חיפוש"
                        >
                            <Search className="w-5 h-5" />
                        </button>
                        <button
                            onClick={() => router.push('/customers/add')}
                            className="p-3 text-gray-400 hover:text-green-600 hover:bg-green-50 rounded-lg transition-all duration-300"
                            title="הוסף לקוח חדש"
                            aria-label="הוסף לקוח חדש"
                        >
                            <Plus className="w-5 h-5" />
                        </button>
                        <button
                            onClick={() => {
                                const { openAddPhoneModal } = useUIStore.getState();
                                openAddPhoneModal();
                            }}
                            className="p-3 text-gray-400 hover:text-blue-600 hover:bg-blue-50 rounded-lg transition-all duration-300"
                            title="הוסף דומיין חדש"
                            aria-label="הוסף דומיין חדש"
                        >
                            <Globe className="w-5 h-5" />
                        </button>
                        <button
                            className="p-3 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg transition-all duration-300"
                            title="היסטוריה"
                            aria-label="היסטוריה"
                        >
                            <Clock className="w-5 h-5" />
                        </button>
                        <button
                            className="p-3 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg transition-all duration-300"
                            title="התראות"
                            aria-label="התראות"
                        >
                            <Bell className="w-5 h-5" />
                        </button>
                        <button
                            className="p-3 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg transition-all duration-300"
                            title="הודעות"
                            aria-label="הודעות"
                        >
                            <Mail className="w-5 h-5" />
                        </button>
                    </div>

                    {/* Right Side - Backup Button */}
                    <div className="flex items-center space-x-3 space-x-reverse">
                        <button
                            onClick={() => window.open('/create-backup.html', '_blank')}
                            className="p-3 text-gray-400 hover:text-purple-600 hover:bg-purple-50 rounded-lg transition-all duration-300"
                            title="צור גיבוי מלא"
                            aria-label="צור גיבוי מלא"
                        >
                            <HardDrive className="w-5 h-5" />
                        </button>
                    </div>
                </div>
            </div>
        </header>
    );
}
