'use client';

import { Phone } from '@/types/phone';
import { BarChart3, PieChart } from 'lucide-react';

interface StatsChartProps {
    phones: Phone[];
}

export default function StatsChart({ phones }: StatsChartProps) {
    // Calculate data for charts
    const statusData = {
        paid: phones.filter(d => d.status === 'paid').length,
        pending: phones.filter(d => d.status === 'pending').length,
        overdue: phones.filter(d => d.status === 'overdue').length,
    };

    const priorityData = {
        high: phones.filter(d => d.priority === 'high').length,
        medium: phones.filter(d => d.priority === 'medium').length,
        low: phones.filter(d => d.priority === 'low').length,
    };

    const total = phones.length;
    const maxStatus = Math.max(statusData.paid, statusData.pending, statusData.overdue);
    const maxPriority = Math.max(priorityData.high, priorityData.medium, priorityData.low);

    return (
        <div className="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-8">
            {/* Status Chart */}
            <div className="bg-white rounded-lg shadow-sm border p-6">
                <div className="flex items-center mb-4">
                    <BarChart3 className="w-5 h-5 text-gray-600 ml-2" />
                    <h3 className="text-lg font-semibold text-gray-900">התפלגות סטטוס</h3>
                </div>
                <div className="space-y-4">
                    <div>
                        <div className="flex justify-between text-sm mb-1">
                            <span className="text-green-600">שולם</span>
                            <span className="font-medium">{statusData.paid}</span>
                        </div>
                        <div className="w-full bg-gray-200 rounded-full h-2">
                            <div
                                className="bg-green-500 h-2 rounded-full transition-all duration-300"
                                style={{ width: `${maxStatus > 0 ? (statusData.paid / maxStatus) * 100 : 0}%` }}
                            ></div>
                        </div>
                    </div>
                    <div>
                        <div className="flex justify-between text-sm mb-1">
                            <span className="text-yellow-600">ממתין</span>
                            <span className="font-medium">{statusData.pending}</span>
                        </div>
                        <div className="w-full bg-gray-200 rounded-full h-2">
                            <div
                                className="bg-yellow-500 h-2 rounded-full transition-all duration-300"
                                style={{ width: `${maxStatus > 0 ? (statusData.pending / maxStatus) * 100 : 0}%` }}
                            ></div>
                        </div>
                    </div>
                    <div>
                        <div className="flex justify-between text-sm mb-1">
                            <span className="text-red-600">פיגור</span>
                            <span className="font-medium">{statusData.overdue}</span>
                        </div>
                        <div className="w-full bg-gray-200 rounded-full h-2">
                            <div
                                className="bg-red-500 h-2 rounded-full transition-all duration-300"
                                style={{ width: `${maxStatus > 0 ? (statusData.overdue / maxStatus) * 100 : 0}%` }}
                            ></div>
                        </div>
                    </div>
                </div>
            </div>

            {/* Priority Chart */}
            <div className="bg-white rounded-lg shadow-sm border p-6">
                <div className="flex items-center mb-4">
                    <PieChart className="w-5 h-5 text-gray-600 ml-2" />
                    <h3 className="text-lg font-semibold text-gray-900">התפלגות עדיפות</h3>
                </div>
                <div className="space-y-4">
                    <div>
                        <div className="flex justify-between text-sm mb-1">
                            <span className="text-red-600">גבוהה</span>
                            <span className="font-medium">{priorityData.high}</span>
                        </div>
                        <div className="w-full bg-gray-200 rounded-full h-2">
                            <div
                                className="bg-red-500 h-2 rounded-full transition-all duration-300"
                                style={{ width: `${maxPriority > 0 ? (priorityData.high / maxPriority) * 100 : 0}%` }}
                            ></div>
                        </div>
                    </div>
                    <div>
                        <div className="flex justify-between text-sm mb-1">
                            <span className="text-yellow-600">בינונית</span>
                            <span className="font-medium">{priorityData.medium}</span>
                        </div>
                        <div className="w-full bg-gray-200 rounded-full h-2">
                            <div
                                className="bg-yellow-500 h-2 rounded-full transition-all duration-300"
                                style={{ width: `${maxPriority > 0 ? (priorityData.medium / maxPriority) * 100 : 0}%` }}
                            ></div>
                        </div>
                    </div>
                    <div>
                        <div className="flex justify-between text-sm mb-1">
                            <span className="text-green-600">נמוכה</span>
                            <span className="font-medium">{priorityData.low}</span>
                        </div>
                        <div className="w-full bg-gray-200 rounded-full h-2">
                            <div
                                className="bg-green-500 h-2 rounded-full transition-all duration-300"
                                style={{ width: `${maxPriority > 0 ? (priorityData.low / maxPriority) * 100 : 0}%` }}
                            ></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
}
