'use client';

import { Search, Filter, RotateCcw, Plus, Upload, Download } from 'lucide-react';
import { usePhoneStore } from '@/store/sqliteStore';
import { useUIStore } from '@/store/uiStore';
import { useEffect } from 'react';

export default function SearchFilters() {
    const {
        filters,
        setFilters,
        applyFilters,
        resetFilters
    } = usePhoneStore();

    const { openAddPhoneModal, openImportCSVModal, openExportCSVModal } = useUIStore();

    // Auto-apply filters when they change
    useEffect(() => {
        applyFilters();
    }, [filters, applyFilters]);

    return (
        <div className="bg-white rounded-lg shadow-sm border p-6 mb-6">
            <div className="flex items-center mb-4">
                <Filter className="w-5 h-5 text-gray-600 ml-2" />
                <h3 className="text-lg font-semibold text-gray-900">סינונים</h3>
            </div>

            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-4">
                {/* Search Input */}
                <div className="lg:col-span-2">
                    <label className="block text-sm font-medium text-gray-700 mb-2">
                        חיפוש
                    </label>
                    <div className="relative">
                        <div className="absolute inset-y-0 right-0 pr-3 flex items-center pointer-events-none">
                            <Search className="h-4 w-4 text-gray-400" />
                        </div>
                        <input
                            type="text"
                            value={filters.search}
                            onChange={(e) => setFilters({ search: e.target.value })}
                            placeholder="חפש דומיינים..."
                            className="block w-full pr-10 pl-3 py-2 border border-gray-300 rounded-md leading-5 bg-white placeholder-gray-500 focus:outline-none focus:placeholder-gray-400 focus:ring-1 focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                        />
                    </div>
                </div>

                {/* Priority Filter */}
                <div>
                    <label className="block text-sm font-medium text-gray-700 mb-2">
                        עדיפות
                    </label>
                    <select
                        value={filters.priority}
                        onChange={(e) => setFilters({ priority: e.target.value as 'all' | 'high' | 'medium' | 'low' })}
                        className="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                        aria-label="בחר עדיפות"
                    >
                        <option value="all">הכל</option>
                        <option value="high">גבוהה</option>
                        <option value="medium">בינונית</option>
                        <option value="low">נמוכה</option>
                    </select>
                </div>

                {/* Status Filter */}
                <div>
                    <label className="block text-sm font-medium text-gray-700 mb-2">
                        סטטוס תשלום
                    </label>
                    <select
                        value={filters.status}
                        onChange={(e) => setFilters({ status: e.target.value as any })}
                        className="block w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 sm:text-sm"
                        aria-label="בחר סטטוס תשלום"
                    >
                        <option value="all">הכל</option>
                        <option value="paid">שולם</option>
                        <option value="pending">ממתין</option>
                        <option value="overdue">פיגור</option>
                        <option value="free">חינם</option>
                        <option value="renewal">לחידוש</option>
                        <option value="paused">מושהה</option>
                        <option value="delete_backup">למחוק יש גיבוי</option>
                        <option value="delete_no_backup">למחוק אין גיבוי</option>
                    </select>
                </div>

            </div>

            {/* Action Buttons */}
            <div className="flex items-center justify-between">
                <div className="flex space-x-3 space-x-reverse">
                    <button
                        onClick={openAddPhoneModal}
                        className="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-green-600 hover:bg-green-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500"
                    >
                        <Plus className="w-4 h-4 ml-2" />
                        הוסף דומיין חדש
                    </button>
                    <button
                        onClick={applyFilters}
                        className="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                    >
                        <Search className="w-4 h-4 ml-2" />
                        חיפוש
                    </button>
                    <button
                        onClick={resetFilters}
                        className="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                    >
                        <RotateCcw className="w-4 h-4 ml-2" />
                        אפס
                    </button>
                    <button
                        onClick={openImportCSVModal}
                        className="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                        title="ייבוא CSV"
                        aria-label="ייבוא CSV"
                    >
                        <Upload className="w-4 h-4 ml-2" />
                        יבוא CSV
                    </button>
                    <button
                        onClick={openExportCSVModal}
                        className="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-purple-600 hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500"
                        title="ייצוא CSV"
                        aria-label="ייצוא CSV"
                    >
                        <Download className="w-4 h-4 ml-2" />
                        יצוא CSV
                    </button>
                </div>

                {/* Show Entries */}
                <div className="flex items-center space-x-2 space-x-reverse">
                    <label className="text-sm text-gray-700">Show</label>
                    <select
                        value={filters.showEntries}
                        onChange={(e) => setFilters({ showEntries: Number(e.target.value) })}
                        className="block px-3 py-1 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500 text-sm"
                        aria-label="בחר מספר רשומות להצגה"
                    >
                        <option value={10}>10</option>
                        <option value={25}>25</option>
                        <option value={50}>50</option>
                        <option value={100}>100</option>
                    </select>
                    <span className="text-sm text-gray-700">entries</span>
                </div>
            </div>
        </div>
    );
}
