const Database = require('better-sqlite3');
const path = require('path');

console.log('🔧 Updating notes table to include user_id...');

const notesDbPath = path.join(process.cwd(), 'notes.db');
const notesDb = new Database(notesDbPath);

try {
    // Check if user_id column exists
    const columns = notesDb.prepare(`PRAGMA table_info(notes)`).all();
    const hasUserId = columns.some(col => col.name === 'user_id');

    if (!hasUserId) {
        console.log('Adding user_id column to notes table...');
        notesDb.exec(`
            ALTER TABLE notes ADD COLUMN user_id TEXT;
        `);
        console.log('✅ user_id column added to notes');
    } else {
        console.log('✓ user_id column already exists');
    }

    // Check if user_id column exists in lists
    const listColumns = notesDb.prepare(`PRAGMA table_info(lists)`).all();
    const listHasUserId = listColumns.some(col => col.name === 'user_id');

    if (!listHasUserId) {
        console.log('Adding user_id column to lists table...');
        notesDb.exec(`
            ALTER TABLE lists ADD COLUMN user_id TEXT;
        `);
        console.log('✅ user_id column added to lists');
    } else {
        console.log('✓ user_id column already exists in lists');
    }

    // Get admin user ID from auth.db
    const authDbPath = path.join(process.cwd(), 'auth.db');
    let adminUserId = null;

    try {
        const authDb = new Database(authDbPath);
        const admin = authDb.prepare(`SELECT id FROM users WHERE email = ? OR role = 'ADMIN' LIMIT 1`).get('titiads2000@gmail.com');
        if (admin) {
            adminUserId = admin.id;
            console.log(`✅ Found admin user: ${adminUserId}`);
        }
        authDb.close();
    } catch (err) {
        console.log('⚠️ Could not get admin user ID:', err.message);
    }

    // Update existing notes and lists to belong to admin
    if (adminUserId) {
        const notesUpdated = notesDb.prepare(`UPDATE notes SET user_id = ? WHERE user_id IS NULL`).run(adminUserId);
        const listsUpdated = notesDb.prepare(`UPDATE lists SET user_id = ? WHERE user_id IS NULL`).run(adminUserId);
        console.log(`✅ Updated ${notesUpdated.changes} notes to belong to admin`);
        console.log(`✅ Updated ${listsUpdated.changes} lists to belong to admin`);
    }

    console.log('');
    console.log('🎉 Notes table updated successfully!');

    notesDb.close();
} catch (error) {
    console.error('❌ Error updating notes table:', error);
    notesDb.close();
    process.exit(1);
}

