/**
 * Seed Notes Data
 * מילוי נתונים לדוגמה למודול הפתקים
 */

import { getNotesDatabase } from '../src/lib/notes-db';
import { addDays } from 'date-fns';

async function seedNotesData() {
    const db = await getNotesDatabase();

    console.log('🌱 Starting notes seed...');

    // Clear existing data
    await db.run('DELETE FROM notes');
    await db.run('DELETE FROM lists');

    // Seed Lists
    const lists = [
        {
            id: 'list-1',
            name: 'חודש גוגל',
            icon: '🌙',
            color: '#4A90E2',
            sort_order: 1,
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'list-2',
            name: 'חייבים כסף 2025',
            icon: '💰',
            color: '#27AE60',
            sort_order: 2,
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'list-3',
            name: 'מה צריך',
            icon: '🛒',
            color: '#F39C12',
            sort_order: 3,
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'list-4',
            name: 'זמויים חדשוּש',
            icon: '📱',
            color: '#9B59B6',
            sort_order: 4,
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'list-5',
            name: 'כללי',
            icon: '📝',
            color: '#95A5A6',
            sort_order: 5,
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
    ];

    for (const list of lists) {
        await db.run(
            `INSERT INTO lists (id, name, icon, color, sort_order, created_at, updated_at)
       VALUES (?, ?, ?, ?, ?, ?, ?)`,
            [list.id, list.name, list.icon, list.color, list.sort_order, list.created_at, list.updated_at]
        );
    }

    console.log(`✅ Seeded ${lists.length} lists`);

    // Seed Notes
    const notes = [
        {
            id: 'note-1',
            list_id: 'list-1',
            title: 'פגישה עם צוות הפיתוח',
            description: 'לדון על האפליקציה החדשה ולתכנן את הספרינט הבא',
            done: 0,
            important: 1,
            flagged: 0,
            due_date: addDays(new Date(), 2).toISOString(),
            subtasks: JSON.stringify([
                { id: 'st-1', title: 'הכנת מצגת', done: true },
                { id: 'st-2', title: 'שליחת סיכום', done: false },
            ]),
            tags: JSON.stringify(['עבודה', 'פגישות']),
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'note-2',
            list_id: 'list-3',
            title: 'קניות לשבת',
            description: 'ירקות, פירות, לחם, חלב',
            done: 0,
            important: 0,
            flagged: 1,
            due_date: addDays(new Date(), 1).toISOString(),
            subtasks: JSON.stringify([]),
            tags: JSON.stringify(['בית', 'קניות']),
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'note-3',
            list_id: 'list-2',
            title: 'גבייה מלקוח דוד',
            description: 'חוב של 5000 ש״ח לפרויקט האתר',
            done: 0,
            important: 1,
            flagged: 1,
            due_date: addDays(new Date(), -3).toISOString(), // Overdue
            subtasks: JSON.stringify([]),
            tags: JSON.stringify(['כסף', 'דחוף']),
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'note-4',
            list_id: 'list-5',
            title: 'לתזמן בדיקת שיניים',
            description: '',
            done: 0,
            important: 0,
            flagged: 0,
            due_date: addDays(new Date(), 7).toISOString(),
            subtasks: JSON.stringify([]),
            tags: JSON.stringify(['בריאות']),
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'note-5',
            list_id: 'list-1',
            title: 'לסיים דוח חודשי',
            description: 'דוח ביצועים לחודש אוקטובר',
            done: 1,
            important: 0,
            flagged: 0,
            due_date: null,
            subtasks: JSON.stringify([
                { id: 'st-3', title: 'איסוף נתונים', done: true },
                { id: 'st-4', title: 'ניתוח גרפים', done: true },
                { id: 'st-5', title: 'כתיבת סיכום', done: true },
            ]),
            tags: JSON.stringify(['עבודה', 'דוחות']),
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'note-6',
            list_id: 'list-4',
            title: 'לבדוק הצעת מחיר חדשה',
            description: 'פרויקט אפליקציה למסעדה',
            done: 0,
            important: 1,
            flagged: 0,
            due_date: addDays(new Date(), 5).toISOString(),
            subtasks: JSON.stringify([]),
            tags: JSON.stringify(['עסקים', 'הצעות']),
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'note-7',
            list_id: 'list-3',
            title: 'להזמין מתנה ליום הולדת',
            description: 'יום הולדת של שרה',
            done: 0,
            important: 0,
            flagged: 0,
            due_date: addDays(new Date(), 10).toISOString(),
            subtasks: JSON.stringify([]),
            tags: JSON.stringify(['אישי', 'מתנות']),
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
        {
            id: 'note-8',
            list_id: null, // Inbox
            title: 'רעיון לפוסט בלוג',
            description: 'איך לבנות מערכת ניהול משימות ב-React',
            done: 0,
            important: 0,
            flagged: 0,
            due_date: null,
            subtasks: JSON.stringify([]),
            tags: JSON.stringify(['כתיבה', 'רעיונות']),
            created_at: new Date().toISOString(),
            updated_at: new Date().toISOString(),
        },
    ];

    for (const note of notes) {
        await db.run(
            `INSERT INTO notes (
        id, list_id, title, description, done, important, flagged,
        due_date, subtasks, tags, created_at, updated_at
      ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`,
            [
                note.id,
                note.list_id,
                note.title,
                note.description,
                note.done,
                note.important,
                note.flagged,
                note.due_date,
                note.subtasks,
                note.tags,
                note.created_at,
                note.updated_at,
            ]
        );
    }

    console.log(`✅ Seeded ${notes.length} notes`);
    console.log('🎉 Notes seed completed!');

    process.exit(0);
}

seedNotesData().catch((error) => {
    console.error('❌ Seed failed:', error);
    process.exit(1);
});

