const Database = require('better-sqlite3');
const path = require('path');

function addSampleTags() {
    const dbPath = path.join(process.cwd(), 'comprehensive.db');
    const db = new Database(dbPath);

    try {
        console.log('Adding sample tags to events...');

        // Get a sample event to add tags to
        const sampleEvent = db.prepare('SELECT id FROM events LIMIT 1').get();

        if (sampleEvent) {
            const sampleTags = [
                {
                    id: 'tag_1',
                    name: 'חשוב',
                    color: '#EF4444',
                    description: 'אירועים חשובים'
                },
                {
                    id: 'tag_2',
                    name: 'פגישה',
                    color: '#10B981',
                    description: 'פגישות עם לקוחות'
                },
                {
                    id: 'tag_3',
                    name: 'דחוף',
                    color: '#F59E0B',
                    description: 'אירועים דחופים'
                }
            ];

            // Update the sample event with tags
            db.prepare('UPDATE events SET tags = ? WHERE id = ?').run(
                JSON.stringify(sampleTags),
                sampleEvent.id
            );

            console.log('✅ Sample tags added to event:', sampleEvent.id);
            console.log('Sample tags:', sampleTags);
        } else {
            console.log('No events found to add tags to');
        }

    } catch (error) {
        console.error('Error adding sample tags:', error);
    } finally {
        db.close();
    }
}

addSampleTags();
