'use client';

import Link from 'next/link';
import { Plus } from 'lucide-react';

interface Props {
    defaultCustomerId?: string;
    defaultCustomerName?: string;
    defaultDomainId?: string;
    defaultDomainName?: string;
    defaultProjectId?: string;
    defaultProjectName?: string;
    variant?: 'primary' | 'secondary' | 'minimal';
    label?: string;
    className?: string;
}

export default function CreateTaskButton({
    defaultCustomerId,
    defaultCustomerName,
    defaultDomainId,
    defaultDomainName,
    defaultProjectId,
    defaultProjectName,
    variant = 'primary',
    label,
    className = ''
}: Props) {
    // בניית Query Params
    const params = new URLSearchParams();
    if (defaultCustomerId) params.set('customer_id', defaultCustomerId);
    if (defaultCustomerName) params.set('customer_name', defaultCustomerName);
    if (defaultDomainId) params.set('domain_id', defaultDomainId);
    if (defaultDomainName) params.set('domain_name', defaultDomainName);
    if (defaultProjectId) params.set('project_id', defaultProjectId);
    if (defaultProjectName) params.set('project_name', defaultProjectName);

    const href = `/tasks/new?${params.toString()}`;

    // קביעת טקסט ברירת מחדל
    let defaultLabel = '➕ משימה חדשה';
    if (defaultDomainId) {
        defaultLabel = '📋 משימה לדומיין';
    } else if (defaultProjectId) {
        defaultLabel = '📊 משימה לפרויקט';
    } else if (defaultCustomerId) {
        defaultLabel = '👤 משימה ללקוח';
    }

    const finalLabel = label || defaultLabel;

    // סגנונות לפי ה-variant
    const variantClasses = {
        primary: 'bg-blue-600 text-white hover:bg-blue-700 px-4 py-2 rounded-md shadow-sm transition-colors',
        secondary: 'bg-white text-blue-600 border border-blue-600 hover:bg-blue-50 px-4 py-2 rounded-md shadow-sm transition-colors',
        minimal: 'text-blue-600 hover:text-blue-700 hover:underline transition-colors'
    };

    return (
        <Link
            href={href}
            className={`inline-flex items-center gap-2 font-medium ${variantClasses[variant]} ${className}`}
        >
            <Plus className="h-4 w-4" />
            <span>{finalLabel}</span>
        </Link>
    );
}
