/**
 * Search Bar Component
 * סרגל חיפוש
 */

'use client';

import { Search, X } from 'lucide-react';
import { useNotesUIStore } from '@/src/store/notesUIStore';
import { Input } from '@/components/ui/input';

export default function SearchBar() {
    const { searchQuery, setSearchQuery } = useNotesUIStore();

    return (
        <div className="relative w-64">
            <Search className="absolute right-3 top-1/2 -translate-y-1/2 w-4 h-4 text-gray-400" />
            <Input
                type="text"
                placeholder="חפש פתקים..."
                value={searchQuery}
                onChange={(e) => setSearchQuery(e.target.value)}
                className="pr-10 pl-10"
            />
            {searchQuery && (
                <button
                    onClick={() => setSearchQuery('')}
                    className="absolute left-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600"
                >
                    <X className="w-4 h-4" />
                </button>
            )}
        </div>
    );
}



