/**
 * Notes List Component
 * רשימת פתקים
 */

'use client';

import { Note } from '@/types/notes';
import NoteItem from './NoteItem';

interface NotesListProps {
    notes: Note[];
}

export default function NotesList({ notes }: NotesListProps) {
    return (
        <div className="p-4 space-y-2">
            {notes.map((note) => (
                <NoteItem key={note.id} note={note} />
            ))}
        </div>
    );
}



