/**
 * Notes Layout Component
 * מבנה עיקרי של מודול הפתקים עם AppLayout (Sidebar + Header)
 */

'use client';

import { useEffect, useState } from 'react';
import { useListsStore } from '@/src/store/listsStore';
import { useNotesStore } from '@/src/store/notesStore';
import { useNotesUIStore } from '@/src/store/notesUIStore';
import { useNotesKeyboardShortcuts } from './KeyboardShortcuts';
import AppLayout from '@/src/components/layout/AppLayout';
import RightPanel from './RightPanel';
import MainArea from './MainArea';
import NoteEditor from './NoteEditor';
import { Menu } from 'lucide-react';

export default function NotesLayout() {
    const { fetchLists } = useListsStore();
    const { fetchNotes } = useNotesStore();
    const { isMobileSidebarOpen, toggleMobileSidebar } = useNotesUIStore();
    const [hasMounted, setHasMounted] = useState(false);

    // Enable keyboard shortcuts
    useNotesKeyboardShortcuts();

    useEffect(() => {
        setHasMounted(true);
        fetchLists();
        fetchNotes();
    }, [fetchLists, fetchNotes]);

    return (
        <AppLayout>
            <div className="h-[calc(100vh-140px)] flex flex-col bg-gray-50" dir="rtl">
                {/* Mobile Header */}
                <div className="lg:hidden bg-white border-b border-gray-200 p-4 flex items-center justify-between">
                    <button
                        onClick={toggleMobileSidebar}
                        className="p-2 hover:bg-gray-100 rounded-lg transition-colors"
                    >
                        <Menu className="w-6 h-6 text-gray-700" />
                    </button>
                    <h1 className="text-xl font-bold text-gray-800">📝 פתקים</h1>
                    <div className="w-10" /> {/* Spacer */}
                </div>

                {/* Main Layout */}
                <div className="flex-1 flex overflow-hidden">
                    {hasMounted ? (
                        <>
                            {/* Right Panel - Lists */}
                            <div
                                className={`
                                            ${isMobileSidebarOpen ? 'translate-x-0' : 'translate-x-full'}
                                            lg:translate-x-0 transition-transform duration-300 ease-in-out
                                            fixed lg:relative inset-y-0 right-0 z-30
                                            w-80 lg:w-80 bg-white lg:bg-transparent
                                            shadow-xl lg:shadow-none
                                        `}
                            >
                                <RightPanel />
                            </div>

                            {/* Overlay for mobile */}
                            {isMobileSidebarOpen && (
                                <div
                                    className="lg:hidden fixed inset-0 bg-black/50 z-20"
                                    onClick={toggleMobileSidebar}
                                />
                            )}

                            {/* Main Area - Notes */}
                            <div className="flex-1 overflow-hidden">
                                <MainArea />
                            </div>
                        </>
                    ) : (
                        <div className="flex-1 flex items-center justify-center">
                            <div className="text-center">
                                <div className="animate-spin rounded-full h-8 w-8 border-b-2 border-purple-600 mx-auto mb-4"></div>
                                <p className="text-gray-600">טוען...</p>
                            </div>
                        </div>
                    )}
                </div>

                {/* Note Editor Sheet */}
                <NoteEditor />
            </div>
        </AppLayout>
    );
}

