/**
 * Keyboard Shortcuts Hook
 * קיצורי מקלדת למודול הפתקים
 */

'use client';

import { useEffect } from 'react';
import { useNotesStore } from '@/src/store/notesStore';
import { useNotesUIStore } from '@/src/store/notesUIStore';
import { useListsStore } from '@/src/store/listsStore';

export function useNotesKeyboardShortcuts() {
    const { selectedListId } = useListsStore();
    const { notes, deleteNoteApi } = useNotesStore();
    const { openNoteEditor, closeNoteEditor, isNoteEditorOpen, setSearchQuery } = useNotesUIStore();

    useEffect(() => {
        const handleKeyDown = (e: KeyboardEvent) => {
            // Ctrl+F - Focus search
            if ((e.ctrlKey || e.metaKey) && e.key === 'f') {
                e.preventDefault();
                const searchInput = document.querySelector('input[placeholder*="חפש"]') as HTMLInputElement;
                if (searchInput) {
                    searchInput.focus();
                }
            }

            // Ctrl+N - New note
            if ((e.ctrlKey || e.metaKey) && e.key === 'n') {
                e.preventDefault();
                const addInput = document.querySelector('input[placeholder*="הוסף משימה"]') as HTMLInputElement;
                if (addInput) {
                    addInput.focus();
                }
            }

            // Escape - Close editor or clear search
            if (e.key === 'Escape') {
                if (isNoteEditorOpen) {
                    closeNoteEditor();
                } else {
                    setSearchQuery('');
                }
            }

            // Delete - Delete selected note (when not in input)
            if (e.key === 'Delete' && !isNoteEditorOpen) {
                const activeElement = document.activeElement;
                if (activeElement?.tagName !== 'INPUT' && activeElement?.tagName !== 'TEXTAREA') {
                    const selectedNote = notes.find(n => n.listId === selectedListId);
                    if (selectedNote && confirm('האם למחוק פתק זה?')) {
                        deleteNoteApi(selectedNote.id);
                    }
                }
            }
        };

        window.addEventListener('keydown', handleKeyDown);
        return () => window.removeEventListener('keydown', handleKeyDown);
    }, [isNoteEditorOpen, notes, selectedListId, deleteNoteApi, closeNoteEditor, setSearchQuery]);
}



