/**
 * Filters Bar Component
 * סרגל פילטרים ומיון
 */

'use client';

import { useNotesUIStore } from '@/src/store/notesUIStore';
import { FilterType, SortType } from '@/types/notes';
import { Filter, ArrowUpDown } from 'lucide-react';

export default function FiltersBar() {
    const { filter, sortBy, setFilter, setSortBy } = useNotesUIStore();

    const filterOptions: { value: FilterType; label: string }[] = [
        { value: 'all', label: 'הכל' },
        { value: 'open', label: 'פתוחות' },
        { value: 'completed', label: 'הושלמו' },
    ];

    const sortOptions: { value: SortType; label: string }[] = [
        { value: 'date', label: 'תאריך' },
        { value: 'importance', label: 'חשיבות' },
        { value: 'alphabetical', label: 'אלפבתי' },
        { value: 'dueDate', label: 'תאריך יעד' },
    ];

    return (
        <div className="flex items-center gap-4">
            {/* Filter */}
            <div className="flex items-center gap-2">
                <Filter className="w-4 h-4 text-gray-500" />
                <div className="flex gap-1">
                    {filterOptions.map((option) => (
                        <button
                            key={option.value}
                            onClick={() => setFilter(option.value)}
                            className={`
                px-3 py-1.5 rounded-lg text-sm font-medium transition-colors
                ${filter === option.value
                                    ? 'bg-purple-600 text-white'
                                    : 'bg-gray-100 text-gray-700 hover:bg-gray-200'
                                }
              `}
                        >
                            {option.label}
                        </button>
                    ))}
                </div>
            </div>

            {/* Sort */}
            <div className="flex items-center gap-2">
                <ArrowUpDown className="w-4 h-4 text-gray-500" />
                <select
                    value={sortBy}
                    onChange={(e) => setSortBy(e.target.value as SortType)}
                    className="
            px-3 py-1.5 rounded-lg text-sm font-medium
            bg-gray-100 text-gray-700 hover:bg-gray-200
            border-0 focus:ring-2 focus:ring-purple-500
            transition-colors cursor-pointer
          "
                >
                    {sortOptions.map((option) => (
                        <option key={option.value} value={option.value}>
                            {option.label}
                        </option>
                    ))}
                </select>
            </div>
        </div>
    );
}



