/**
 * Empty State Component
 * מצב ריקון
 */

'use client';

import { FileText } from 'lucide-react';

interface EmptyStateProps {
    title: string;
    description?: string;
}

export default function EmptyState({ title, description }: EmptyStateProps) {
    return (
        <div className="h-full flex items-center justify-center">
            <div
                className="text-center p-8 max-w-md"
                style={{
                    backgroundImage: 'url(https://images.unsplash.com/photo-1519682577862-22b62b24e493?w=1200&q=80)',
                    backgroundSize: 'cover',
                    backgroundPosition: 'center',
                    position: 'relative',
                }}
            >
                {/* Overlay */}
                <div className="absolute inset-0 bg-white/90 backdrop-blur-sm rounded-2xl" />

                {/* Content */}
                <div className="relative z-10">
                    <div className="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mx-auto mb-4">
                        <FileText className="w-8 h-8 text-purple-600" />
                    </div>
                    <h3 className="text-xl font-bold text-gray-900 mb-2">{title}</h3>
                    {description && (
                        <p className="text-gray-600">{description}</p>
                    )}
                </div>
            </div>
        </div>
    );
}



