/**
 * Add Note Bar Component
 * בר הוספת פתק מהיר
 */

'use client';

import { useState, KeyboardEvent } from 'react';
import { useNotesStore } from '@/src/store/notesStore';
import { useListsStore } from '@/src/store/listsStore';
import { Input } from '@/components/ui/input';
import { Plus } from 'lucide-react';
import toast from 'react-hot-toast';

interface AddNoteBarProps {
    listId: string;
}

export default function AddNoteBar({ listId }: AddNoteBarProps) {
    const [title, setTitle] = useState('');
    const { createNote } = useNotesStore();
    const { selectedListId } = useListsStore();

    const handleSubmit = async () => {
        if (!title.trim()) {
            toast.error('נא להזין כותרת לפתק');
            return;
        }

        try {
            await createNote({
                title: title.trim(),
                listId: selectedListId === 'all' ? null : selectedListId,
                done: false,
                important: false,
                flagged: false,
            });

            setTitle('');
            toast.success('הפתק נוסף בהצלחה! ✅');
        } catch (error) {
            toast.error('שגיאה בהוספת הפתק');
            console.error('Error adding note:', error);
        }
    };

    const handleKeyDown = (e: KeyboardEvent<HTMLInputElement>) => {
        if (e.key === 'Enter') {
            handleSubmit();
        }
    };

    return (
        <div className="border-t border-gray-200 p-4 bg-white">
            <div className="flex items-center gap-3">
                <div className="flex-1 relative">
                    <Plus className="absolute right-3 top-1/2 -translate-y-1/2 w-5 h-5 text-gray-400" />
                    <Input
                        type="text"
                        placeholder="הוסף משימה חדשה... (לחץ Enter)"
                        value={title}
                        onChange={(e) => setTitle(e.target.value)}
                        onKeyDown={handleKeyDown}
                        className="pr-11 py-6 text-base"
                    />
                </div>
                <button
                    onClick={handleSubmit}
                    className="
            px-6 py-3 rounded-xl
            bg-purple-600 hover:bg-purple-700
            text-white font-medium
            transition-all duration-200
            shadow-md hover:shadow-lg
            transform hover:scale-105
          "
                >
                    הוסף
                </button>
            </div>
        </div>
    );
}



