'use client';

import { PREDEFINED_COLORS } from '@/types/tags';

interface ColorPickerProps {
    selectedColor: string;
    onColorChange: (color: string) => void;
    className?: string;
}

export function ColorPicker({ selectedColor, onColorChange, className = '' }: ColorPickerProps) {
    return (
        <div className={`flex flex-wrap gap-2 ${className}`}>
            {PREDEFINED_COLORS.map((color) => (
                <button
                    key={color.value}
                    type="button"
                    onClick={() => onColorChange(color.value)}
                    className={`w-8 h-8 rounded-full border-2 transition-all hover:scale-110 ${
                        selectedColor === color.value
                            ? 'border-gray-800 shadow-lg'
                            : 'border-gray-300 hover:border-gray-500'
                    }`}
                    style={{ backgroundColor: color.value }}
                    title={color.name}
                    aria-label={`בחר צבע ${color.name}`}
                />
            ))}
        </div>
    );
}
