'use client';

import { useEffect, useRef, useState } from 'react';
import 'react-quill-new/dist/quill.snow.css';

interface RichTextEditorProps {
    value: string;
    onChange: (value: string) => void;
    placeholder?: string;
}

export default function RichTextEditor({ value, onChange, placeholder }: RichTextEditorProps) {
    const [isMounted, setIsMounted] = useState(false);
    const ReactQuill = useRef<any>(null);

    useEffect(() => {
        setIsMounted(true);
        // Dynamic import של React Quill New (תומך ב-React 18+)
        import('react-quill-new').then((mod) => {
            ReactQuill.current = mod.default;
        });
    }, []);

    const modules = {
        toolbar: [
            [{ 'header': [1, 2, 3, false] }],
            ['bold', 'italic', 'underline', 'strike'],
            [{ 'color': [] }, { 'background': [] }],
            [{ 'list': 'ordered' }, { 'list': 'bullet' }],
            [{ 'align': [] }],
            ['link'],
            ['clean']
        ],
    };

    if (!isMounted || !ReactQuill.current) {
        return (
            <div className="h-[400px] bg-gray-100 rounded-md animate-pulse flex items-center justify-center">
                <p className="text-gray-500">טוען עורך...</p>
            </div>
        );
    }

    const QuillEditor = ReactQuill.current;

    return (
        <div dir="ltr" className="rich-text-editor">
            <QuillEditor
                theme="snow"
                value={value}
                onChange={onChange}
                modules={modules}
                placeholder={placeholder || 'כתוב את תוכן האימייל כאן...'}
                className="bg-white rounded-lg"
                style={{ height: '400px', marginBottom: '50px' }}
            />
        </div>
    );
}

