'use client';

import React from 'react';
import {
    Users,
    Globe,
    CheckCircle,
    AlertTriangle,
    Clock,
    DollarSign,
    TrendingUp,
    FileText,
    Target,
    Calendar,
    Phone,
    Mail
} from 'lucide-react';

interface StatCardProps {
    title: string;
    value: number;
    color: 'blue-light' | 'blue-dark' | 'orange' | 'blue' | 'red' | 'yellow' | 'green' | 'purple';
    icon?: React.ReactNode;
    subtitle?: string;
    urgent?: boolean;
}

export const StatCard: React.FC<StatCardProps> = ({
    title,
    value,
    color,
    icon,
    subtitle,
    urgent = false
}) => {
    const colorClasses = {
        'blue-light': 'bg-white border-2 border-blue-200 text-gray-900 hover:border-blue-300',
        'blue-dark': 'bg-blue-600 text-white hover:bg-blue-700',
        'orange': 'bg-orange-500 text-white hover:bg-orange-600',
        'blue': 'bg-blue-500 text-white hover:bg-blue-600',
        'red': 'bg-red-500 text-white hover:bg-red-600',
        'yellow': 'bg-yellow-500 text-white hover:bg-yellow-600',
        'green': 'bg-green-500 text-white hover:bg-green-600',
        'purple': 'bg-purple-500 text-white hover:bg-purple-600'
    };

    const iconClasses = {
        'blue-light': 'text-blue-500',
        'blue-dark': 'text-blue-200',
        'orange': 'text-orange-200',
        'blue': 'text-blue-200',
        'red': 'text-red-200',
        'yellow': 'text-yellow-200',
        'green': 'text-green-200',
        'purple': 'text-purple-200'
    };

    const getDefaultIcon = () => {
        if (title.includes('לקוחות')) return <Users className="w-8 h-8" />;
        if (title.includes('דומיינים')) return <Globe className="w-8 h-8" />;
        if (title.includes('משימות')) return <CheckCircle className="w-8 h-8" />;
        if (title.includes('פרויקטים')) return <Target className="w-8 h-8" />;
        if (title.includes('הכנסות') || title.includes('כספים')) return <DollarSign className="w-8 h-8" />;
        if (title.includes('מכירה')) return <TrendingUp className="w-8 h-8" />;
        if (title.includes('הזמנות')) return <FileText className="w-8 h-8" />;
        if (title.includes('קשר')) return <Phone className="w-8 h-8" />;
        return <Users className="w-8 h-8" />;
    };

    return (
        <div className={`p-6 rounded-xl border-2 shadow-lg hover:shadow-xl transition-all duration-300 ${colorClasses[color]} group`}>
            <div className="flex items-start justify-between">
                <div className="flex-1">
                    <div className="flex items-center gap-3 mb-3">
                        <div className={`${iconClasses[color]} group-hover:scale-110 transition-transform duration-300`}>
                            {icon || getDefaultIcon()}
                        </div>
                        <h3 className="text-sm font-semibold leading-tight">{title}</h3>
                    </div>

                    <div className="space-y-2">
                        <p className="text-4xl font-bold tracking-tight">{value}</p>
                        {subtitle && (
                            <p className={`text-xs font-medium ${urgent ? 'text-red-600' : 'text-gray-500'
                                }`}>
                                {subtitle}
                            </p>
                        )}
                    </div>
                </div>
            </div>
        </div>
    );
};
