'use client';

import React from 'react';
import { StatCard } from './StatCard';
import { DashboardStats } from '@/src/types/customer';

interface DashboardGridProps {
    stats: DashboardStats;
}

export const DashboardGrid: React.FC<DashboardGridProps> = ({ stats }) => {
    return (
        <div className="space-y-8">
            {/* Main Stats Row - 4 Primary Cards */}
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                <StatCard
                    title="לקוחות זכייה"
                    value={stats.wonQuotes}
                    color="purple"
                    urgent={false}
                />
                <StatCard
                    title="הזמנות מחיר או הזמנה פתוחה"
                    value={stats.openQuotes}
                    color="green"
                    urgent={false}
                />
                <StatCard
                    title="לקוחות שליווי הלילות השבועות"
                    value={stats.unpaidInvoices}
                    color="yellow"
                    subtitle={`${stats.unpaidInvoicesPercent}% ממד כל הלקוחות`}
                    urgent={false}
                />
                <StatCard
                    title="לקוחות עם השבועות מאוחרות"
                    value={stats.latePayments}
                    color="red"
                    subtitle={`${stats.latePaymentsPercent}% ממד כל הלקוחות`}
                    urgent={true}
                />
            </div>

            {/* Secondary Stats Row - 6 Cards */}
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-4">
                <StatCard
                    title="מד כל הלקוחות"
                    value={stats.totalCustomers}
                    color="blue"
                />
                <StatCard
                    title="מד אנשי המכירה"
                    value={stats.salesReps}
                    color="orange"
                />
                <StatCard
                    title="אנשי קשר שכנסו היום"
                    value={stats.contactsToday}
                    color="blue-dark"
                />
                <StatCard
                    title="אנשי קשר שכנסו 7-3 הימים האחרונים"
                    value={stats.contactsLastWeek}
                    color="blue-light"
                />
                <StatCard
                    title="לקוחות עם בקשות הערכת הטמיר"
                    value={stats.updatedQuoteRequests}
                    color="blue-light"
                />
                <StatCard
                    title="לקוחות עם בקשות הערכת חדשות"
                    value={stats.newQuoteRequests}
                    color="blue-light"
                />
            </div>

            {/* Projects & Orders Row - 6 Cards */}
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-4">
                <StatCard
                    title="סך הכל הזמנות"
                    value={stats.totalOrders || 0}
                    color="blue-light"
                />
                <StatCard
                    title="לקוחות שם נסיונות פתוחים"
                    value={stats.openOpportunities}
                    color="blue-light"
                    subtitle={`${stats.openOpportunitiesPercent}% ממד כל הלקוחות`}
                />
                <StatCard
                    title="לקוחות בשלב פרויקטים"
                    value={stats.inProgressProjects}
                    color="blue-light"
                />
                <StatCard
                    title="לקוחות שהשמיע מ-בדיקותם"
                    value={stats.completedProjects}
                    color="blue-light"
                />
                <StatCard
                    title="לקוחות שם פרויקטים פתוחים"
                    value={stats.openProjects}
                    color="blue-light"
                />
                <StatCard
                    title="פרויקטים"
                    value={stats.totalProjects}
                    color="blue-light"
                />
            </div>
        </div>
    );
};
