import Sidebar from '@/src/components/layout/Sidebar';
import Header from '@/src/components/layout/Header';
import TasksTable from '@/components/tasks/TasksTable';
import CreateTaskButton from '@/components/tasks/CreateTaskButton';
import TasksStats from '@/components/tasks/TasksStats';

export default async function TasksPage() {
    return (
        <div className="min-h-screen bg-gray-50 flex">
            <Sidebar />
            <div className="flex-1 flex flex-col">
                <Header />
                <div className="flex-1 p-6" dir="rtl">
                    <div className="flex items-center justify-between mb-6">
                        <h1 className="text-2xl font-bold">משימות</h1>
                        <CreateTaskButton />
                    </div>

                    {/* בלוק סטטיסטיקות */}
                    <TasksStats />

                    {/* טבלת המשימות */}
                    <TasksTable />
                </div>
            </div>
        </div>
    );
}


