'use client';

import { useSearchParams } from 'next/navigation';
import Sidebar from '@/src/components/layout/Sidebar';
import TaskForm from '@/components/tasks/TaskForm';
import { Suspense } from 'react';

function NewTaskContent() {
    const searchParams = useSearchParams();
    const customerId = searchParams.get('customer_id') || undefined;
    const domainId = searchParams.get('domain_id') || undefined;
    const projectId = searchParams.get('project_id') || undefined;
    const customerName = searchParams.get('customer_name') || undefined;
    const domainName = searchParams.get('domain_name') || undefined;
    const projectName = searchParams.get('project_name') || undefined;

    // קביעת כותרת דינמית
    let title = 'הוספת משימה';
    if (domainName) {
        title = `הוספת משימה עבור דומיין: ${domainName}`;
    } else if (projectName) {
        title = `הוספת משימה עבור פרויקט: ${projectName}`;
    } else if (customerName) {
        title = `הוספת משימה עבור לקוח: ${customerName}`;
    }

    return (
        <div className="flex-1 p-6" dir="rtl">
            <div className="mb-6">
                <h1 className="text-2xl font-bold">{title}</h1>
                {(customerName || domainName || projectName) && (
                    <p className="text-sm text-gray-600 mt-1">
                        {customerName && <span>👤 {customerName}</span>}
                        {domainName && <span className="mr-2">🌐 {domainName}</span>}
                        {projectName && <span className="mr-2">📊 {projectName}</span>}
                    </p>
                )}
            </div>
            <TaskForm
                mode="create"
                defaultCustomerId={customerId}
                defaultDomainId={domainId}
                defaultProjectId={projectId}
                lockCustomer={!!customerId}
                lockDomain={!!domainId}
                lockProject={!!projectId}
            />
        </div>
    );
}

export default function NewTaskPage() {
    return (
        <div className="min-h-screen bg-gray-50 flex">
            <Sidebar />
            <Suspense fallback={<div className="flex-1 p-6">טוען...</div>}>
                <NewTaskContent />
            </Suspense>
        </div>
    );
}


