'use client';

import StatsCards from '@/src/components/dashboard/StatsCards';
import AdvancedStats from '@/src/components/dashboard/AdvancedStats';
import StatsChart from '@/src/components/dashboard/StatsChart';
import AlertBanners from '@/src/components/dashboard/AlertBanners';
import PhonesTable from '@/src/components/dashboard/PhonesTable';
import SearchFilters from '@/src/components/dashboard/SearchFilters';
import AppLayout from '@/src/components/layout/AppLayout';
import AddPhoneForm from '@/src/components/forms/AddPhoneForm';
import EditPhoneForm from '@/src/components/forms/EditPhoneForm';
import ImportCSVModal from '@/src/components/forms/ImportCSVModal';
import ExportCSVModal from '@/src/components/forms/ExportCSVModal';
import Modal from '@/src/components/modals/Modal';
import { phones } from '@/lib/data';
import { usePhoneStore } from '@/store/sqliteStore';
import { useUIStore } from '@/store/uiStore';
import { useEffect, useRef } from 'react';

export default function Home() {
  const {
    phones: storePhones,
    filteredPhones,
    isLoading,
    error
  } = usePhoneStore();

  console.log('🔍 Store state:', {
    phonesCount: storePhones.length,
    filteredCount: filteredPhones.length,
    isLoading,
    error
  });

  const {
    isAddPhoneModalOpen,
    closeAddPhoneModal,
    isEditPhoneModalOpen,
    closeEditPhoneModal,
    selectedPhoneId,
    isImportCSVModalOpen,
    closeImportCSVModal,
    isExportCSVModalOpen,
    closeExportCSVModal
  } = useUIStore();

  const hasInitialized = useRef(false);

  // Initialize phones from SQLite database
  useEffect(() => {
    if (hasInitialized.current) return;

    const { fetchPhones } = usePhoneStore.getState();
    console.log('🚀 Page mounted, fetching phones from SQLite...');
    fetchPhones();

    hasInitialized.current = true;
  }, []); // Run only once on mount

  // Always use store phones to avoid duplicates
  const displayPhones = storePhones;

  return (
    <AppLayout>
      {/* Stats Cards */}
      <StatsCards phones={storePhones} />

      {/* Advanced Stats */}
      <AdvancedStats phones={storePhones} />

      {/* Stats Charts */}
      <StatsChart phones={storePhones} />

      {/* Alert Banners */}
      <AlertBanners phones={storePhones} />

      {/* Search and Filters */}
      <SearchFilters />

      {/* Domains Table */}
      <PhonesTable phones={filteredPhones} />

      {/* Add Domain Modal */}
      <Modal
        isOpen={isAddPhoneModalOpen}
        onClose={closeAddPhoneModal}
        title="הוסף דומיין חדש"
        size="lg"
      >
        <AddPhoneForm onSuccess={closeAddPhoneModal} />
      </Modal>

      {/* Edit Domain Modal */}
      <Modal
        isOpen={isEditPhoneModalOpen}
        onClose={closeEditPhoneModal}
        title="ערוך דומיין"
        size="lg"
      >
        {selectedPhoneId && (
          <EditPhoneForm
            phoneId={selectedPhoneId}
            onSuccess={closeEditPhoneModal}
          />
        )}
      </Modal>

      {/* Import CSV Modal */}
      {isImportCSVModalOpen && (
        <ImportCSVModal onClose={closeImportCSVModal} />
      )}

      {/* Export CSV Modal */}
      {isExportCSVModalOpen && (
        <ExportCSVModal onClose={closeExportCSVModal} />
      )}
    </AppLayout>
  );
}
