import type { Metadata } from "next";
import { Assistant } from "next/font/google";
import "./globals.css";
import { AuthProvider } from '@/src/components/providers/AuthProvider';

const assistant = Assistant({
  variable: "--font-assistant",
  subsets: ["hebrew", "latin"],
  weight: ["300", "400", "500", "600", "700"],
});

export const metadata: Metadata = {
  title: "מערכת ניהול דומיינים",
  description: "מערכת ניהול דומיינים מתקדמת עם מעקב אחר סטטוס ותשלומים",
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="he" dir="rtl">
      <body
        className={`${assistant.variable} font-sans antialiased`}
      >
        <AuthProvider>
          {children}
        </AuthProvider>
      </body>
    </html>
  );
}
