import Sidebar from '@/src/components/layout/Sidebar';
import Header from '@/src/components/layout/Header';
import EventList from '@/components/events/EventList';

export default function EventsPage() {
    return (
        <div className="min-h-screen bg-gray-50 flex">
            <Sidebar />
            <div className="flex-1 flex flex-col">
                <Header />
                <div className="flex-1 p-6" dir="rtl">
                    <div className="flex items-center justify-between mb-6">
                        <h1 className="text-2xl font-bold">אירועים</h1>
                        <a
                            href="/events/new"
                            className="inline-flex items-center gap-2 font-medium bg-blue-600 text-white hover:bg-blue-700 px-4 py-2 rounded-md shadow-sm transition-colors"
                        >
                            <span>+</span>
                            <span>אירוע חדש</span>
                        </a>
                    </div>
                    <EventList />
                </div>
            </div>
        </div>
    );
}
