'use client';

import React from 'react';
import Sidebar from '@/src/components/layout/Sidebar';
import Header from '@/src/components/layout/Header';
import EventForm from '@/components/events/EventForm';

export default function NewEventPage() {
    return (
        <div className="min-h-screen bg-gray-50 flex">
            <Sidebar />
            <div className="flex-1 flex flex-col">
                <Header />
                <div className="flex-1 p-8" dir="rtl">
                    <div className="mb-6">
                        <h1 className="text-3xl font-bold text-gray-900">אירוע חדש</h1>
                    </div>

                    <EventForm
                        mode="create"
                        onSuccess={() => {
                            window.location.href = '/events';
                        }}
                    />
                </div>
            </div>
        </div>
    );
}