'use client';

import AppLayout from '@/src/components/layout/AppLayout';
import { Card } from '@/components/ui/card';
import { Mail, Send, CheckCircle, XCircle, Clock, TrendingUp } from 'lucide-react';

export default function EmailOverviewPage() {
    // נתונים דמה - לאחר מכן נחבר ל-DB
    const stats = {
        total: 1250,
        sent: 1180,
        delivered: 1120,
        failed: 60,
        pending: 70,
        successRate: 94.9
    };

    const recentActivity = [
        { id: 1, type: 'success', message: 'תזכורת תשלום נשלחה ל-10 לקוחות', time: 'לפני 5 דקות' },
        { id: 2, type: 'success', message: 'אישור תשלום נשלח ללקוח יוסי כהן', time: 'לפני 15 דקות' },
        { id: 3, type: 'error', message: '3 מיילים נכשלו - כתובת לא תקינה', time: 'לפני 30 דקות' },
        { id: 4, type: 'success', message: 'תזכורת חידוש נשלחה ל-25 לקוחות', time: 'לפני שעה' },
    ];

    return (
        <AppLayout>
            <div className="p-8">
                <div className="mb-8">
                    <h1 className="text-3xl font-bold text-gray-900 mb-2">סקירה כללית - מערכת מיילים</h1>
                    <p className="text-gray-600">מעקב אחר פעילות המיילים והסטטיסטיקות</p>
                </div>

                {/* Stats Cards */}
                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-6 mb-8">
                    <Card className="p-6 bg-gradient-to-br from-blue-50 to-blue-100 border-blue-200">
                        <div className="flex items-center justify-between">
                            <div>
                                <p className="text-sm text-blue-600 font-medium mb-1">סה"כ מיילים</p>
                                <p className="text-2xl font-bold text-blue-900">{stats.total}</p>
                            </div>
                            <Mail className="w-8 h-8 text-blue-600" />
                        </div>
                    </Card>

                    <Card className="p-6 bg-gradient-to-br from-purple-50 to-purple-100 border-purple-200">
                        <div className="flex items-center justify-between">
                            <div>
                                <p className="text-sm text-purple-600 font-medium mb-1">נשלחו</p>
                                <p className="text-2xl font-bold text-purple-900">{stats.sent}</p>
                            </div>
                            <Send className="w-8 h-8 text-purple-600" />
                        </div>
                    </Card>

                    <Card className="p-6 bg-gradient-to-br from-green-50 to-green-100 border-green-200">
                        <div className="flex items-center justify-between">
                            <div>
                                <p className="text-sm text-green-600 font-medium mb-1">הגיעו ליעד</p>
                                <p className="text-2xl font-bold text-green-900">{stats.delivered}</p>
                            </div>
                            <CheckCircle className="w-8 h-8 text-green-600" />
                        </div>
                    </Card>

                    <Card className="p-6 bg-gradient-to-br from-red-50 to-red-100 border-red-200">
                        <div className="flex items-center justify-between">
                            <div>
                                <p className="text-sm text-red-600 font-medium mb-1">נכשלו</p>
                                <p className="text-2xl font-bold text-red-900">{stats.failed}</p>
                            </div>
                            <XCircle className="w-8 h-8 text-red-600" />
                        </div>
                    </Card>

                    <Card className="p-6 bg-gradient-to-br from-yellow-50 to-yellow-100 border-yellow-200">
                        <div className="flex items-center justify-between">
                            <div>
                                <p className="text-sm text-yellow-600 font-medium mb-1">ממתינים</p>
                                <p className="text-2xl font-bold text-yellow-900">{stats.pending}</p>
                            </div>
                            <Clock className="w-8 h-8 text-yellow-600" />
                        </div>
                    </Card>

                    <Card className="p-6 bg-gradient-to-br from-indigo-50 to-indigo-100 border-indigo-200">
                        <div className="flex items-center justify-between">
                            <div>
                                <p className="text-sm text-indigo-600 font-medium mb-1">אחוז הצלחה</p>
                                <p className="text-2xl font-bold text-indigo-900">{stats.successRate}%</p>
                            </div>
                            <TrendingUp className="w-8 h-8 text-indigo-600" />
                        </div>
                    </Card>
                </div>

                {/* Recent Activity */}
                <Card className="p-6">
                    <h2 className="text-xl font-bold text-gray-900 mb-6">פעילות אחרונה</h2>
                    <div className="space-y-4">
                        {recentActivity.map((activity) => (
                            <div key={activity.id} className="flex items-center justify-between p-4 bg-gray-50 rounded-lg">
                                <div className="flex items-center gap-4">
                                    {activity.type === 'success' ? (
                                        <div className="w-10 h-10 bg-green-100 rounded-full flex items-center justify-center">
                                            <CheckCircle className="w-5 h-5 text-green-600" />
                                        </div>
                                    ) : (
                                        <div className="w-10 h-10 bg-red-100 rounded-full flex items-center justify-center">
                                            <XCircle className="w-5 h-5 text-red-600" />
                                        </div>
                                    )}
                                    <div>
                                        <p className="text-sm font-medium text-gray-900">{activity.message}</p>
                                        <p className="text-xs text-gray-500">{activity.time}</p>
                                    </div>
                                </div>
                            </div>
                        ))}
                    </div>
                </Card>
            </div>
        </AppLayout>
    );
}



