'use client';

import { useState } from 'react';
import AppLayout from '@/src/components/layout/AppLayout';
import { Card } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { Mail, Plus, Edit, Trash2, CheckCircle, XCircle } from 'lucide-react';

export default function EmailAccountsPage() {
    const [showAddModal, setShowAddModal] = useState(false);

    // נתונים דמה - לאחר מכן נחבר ל-DB
    const emailAccounts = [
        {
            id: 1,
            email: 'sales@tsm.co.il',
            name: 'מכירות',
            host: 'mail.tsm.co.il',
            port: 587,
            isActive: true,
            sentCount: 1250
        },
        {
            id: 2,
            email: 'support@tsm.co.il',
            name: 'תמיכה',
            host: 'mail.tsm.co.il',
            port: 587,
            isActive: true,
            sentCount: 820
        },
        {
            id: 3,
            email: 'info@tsm.co.il',
            name: 'מידע כללי',
            host: 'mail.tsm.co.il',
            port: 587,
            isActive: false,
            sentCount: 0
        },
    ];

    return (
        <AppLayout>
            <div className="p-8">
                <div className="mb-8 flex items-center justify-between">
                    <div>
                        <h1 className="text-3xl font-bold text-gray-900 mb-2">ניהול כתובות מייל</h1>
                        <p className="text-gray-600">נהל את חשבונות המייל המשמשים לשליחה</p>
                    </div>
                    <Button
                        onClick={() => setShowAddModal(true)}
                        className="bg-blue-600 hover:bg-blue-700"
                    >
                        <Plus className="w-4 h-4 ml-2" />
                        הוסף חשבון מייל
                    </Button>
                </div>

                {/* Email Accounts Grid */}
                <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                    {emailAccounts.map((account) => (
                        <Card key={account.id} className="p-6 hover:shadow-lg transition-shadow">
                            <div className="flex items-start justify-between mb-4">
                                <div className="flex items-center gap-3">
                                    <div className={`w-12 h-12 ${account.isActive ? 'bg-blue-100' : 'bg-gray-100'} rounded-full flex items-center justify-center`}>
                                        <Mail className={`w-6 h-6 ${account.isActive ? 'text-blue-600' : 'text-gray-400'}`} />
                                    </div>
                                    <div>
                                        <h3 className="font-semibold text-gray-900">{account.name}</h3>
                                        <p className="text-sm text-gray-500">{account.email}</p>
                                    </div>
                                </div>
                                {account.isActive ? (
                                    <span className="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                        <CheckCircle className="w-3 h-3 ml-1" />
                                        פעיל
                                    </span>
                                ) : (
                                    <span className="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-gray-100 text-gray-600">
                                        <XCircle className="w-3 h-3 ml-1" />
                                        לא פעיל
                                    </span>
                                )}
                            </div>

                            <div className="space-y-2 mb-4">
                                <div className="flex items-center justify-between text-sm">
                                    <span className="text-gray-500">שרת:</span>
                                    <span className="text-gray-900 font-medium">{account.host}</span>
                                </div>
                                <div className="flex items-center justify-between text-sm">
                                    <span className="text-gray-500">פורט:</span>
                                    <span className="text-gray-900 font-medium">{account.port}</span>
                                </div>
                                <div className="flex items-center justify-between text-sm">
                                    <span className="text-gray-500">נשלחו:</span>
                                    <span className="text-gray-900 font-medium">{account.sentCount} מיילים</span>
                                </div>
                            </div>

                            <div className="flex gap-2 pt-4 border-t">
                                <Button
                                    variant="outline"
                                    size="sm"
                                    className="flex-1"
                                >
                                    <Edit className="w-4 h-4 ml-1" />
                                    ערוך
                                </Button>
                                <Button
                                    variant="outline"
                                    size="sm"
                                    className="text-red-600 hover:bg-red-50 hover:text-red-700"
                                >
                                    <Trash2 className="w-4 h-4" />
                                </Button>
                            </div>
                        </Card>
                    ))}
                </div>

                {/* Add Account Modal */}
                {showAddModal && (
                    <div className="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
                        <Card className="w-full max-w-md p-6 m-4">
                            <h2 className="text-2xl font-bold text-gray-900 mb-6">הוסף חשבון מייל</h2>

                            <div className="space-y-4">
                                <div>
                                    <Label htmlFor="name">שם החשבון</Label>
                                    <Input id="name" placeholder="לדוגמה: מכירות" />
                                </div>

                                <div>
                                    <Label htmlFor="email">כתובת מייל</Label>
                                    <Input id="email" type="email" placeholder="sales@example.com" />
                                </div>

                                <div>
                                    <Label htmlFor="host">שרת SMTP</Label>
                                    <Input id="host" placeholder="mail.example.com" />
                                </div>

                                <div className="grid grid-cols-2 gap-4">
                                    <div>
                                        <Label htmlFor="port">פורט</Label>
                                        <Input id="port" type="number" placeholder="587" />
                                    </div>
                                    <div>
                                        <Label htmlFor="secure">SSL/TLS</Label>
                                        <select id="secure" className="w-full px-3 py-2 border border-gray-300 rounded-md">
                                            <option value="false">לא</option>
                                            <option value="true">כן</option>
                                        </select>
                                    </div>
                                </div>

                                <div>
                                    <Label htmlFor="password">סיסמה</Label>
                                    <Input id="password" type="password" placeholder="••••••••" />
                                </div>
                            </div>

                            <div className="flex gap-3 mt-6">
                                <Button
                                    onClick={() => setShowAddModal(false)}
                                    variant="outline"
                                    className="flex-1"
                                >
                                    ביטול
                                </Button>
                                <Button
                                    className="flex-1 bg-blue-600 hover:bg-blue-700"
                                >
                                    שמור
                                </Button>
                            </div>
                        </Card>
                    </div>
                )}
            </div>
        </AppLayout>
    );
}



