import { NextRequest, NextResponse } from 'next/server';
import { openDB } from '@/src/lib/db';

export async function POST(request: NextRequest) {
    try {
        console.log('🔧 Creating task_recordings table...');
        const db = await openDB();

        // Create task_recordings table
        await new Promise((resolve, reject) => {
            db.exec(`
                CREATE TABLE IF NOT EXISTS task_recordings (
                    id INTEGER PRIMARY KEY AUTOINCREMENT,
                    task_id INTEGER NOT NULL,
                    name TEXT NOT NULL,
                    duration REAL NOT NULL,
                    audio_data BLOB NOT NULL,
                    created_at TEXT DEFAULT CURRENT_TIMESTAMP,
                    FOREIGN KEY (task_id) REFERENCES tasks(id) ON DELETE CASCADE
                )
            `, (err) => {
                if (err) reject(err);
                else resolve(true);
            });
        });

        console.log('✅ task_recordings table created');

        // Create index for performance
        await new Promise((resolve, reject) => {
            db.exec(`
                CREATE INDEX IF NOT EXISTS idx_task_recordings_task_id ON task_recordings(task_id);
            `, (err) => {
                if (err) reject(err);
                else resolve(true);
            });
        });

        console.log('✅ Index created');

        return NextResponse.json({
            success: true,
            message: 'טבלת ההקלטות נוצרה בהצלחה!'
        });

    } catch (error: any) {
        console.error('❌ Error creating recordings table:', error);
        return NextResponse.json({
            error: 'שגיאה ביצירת טבלת ההקלטות: ' + error.message
        }, { status: 500 });
    }
}
