import { NextRequest, NextResponse } from 'next/server';
import { openDB } from '@/src/lib/db';

export async function GET(request: NextRequest) {
    try {
        const db = await openDB();

        // Check if task_recordings table exists
        const tableExists = await new Promise((resolve, reject) => {
            db.get("SELECT name FROM sqlite_master WHERE type='table' AND name='task_recordings'", (err, row) => {
                if (err) reject(err);
                else resolve(!!row);
            });
        });

        const response: any = {
            success: true,
            table_exists: tableExists
        };

        if (tableExists) {
            // Get table schema
            const columns = await new Promise((resolve, reject) => {
                db.all("PRAGMA table_info(task_recordings)", (err, rows) => {
                    if (err) reject(err);
                    else resolve(rows);
                });
            });

            // Get count
            const count = await new Promise((resolve, reject) => {
                db.get("SELECT COUNT(*) as count FROM task_recordings", (err, row) => {
                    if (err) reject(err);
                    else resolve((row as any).count);
                });
            });

            response.columns = columns;
            response.count = count;
        }

        return NextResponse.json(response);
    } catch (error: any) {
        console.error('Debug recordings error:', error);
        return NextResponse.json({
            error: 'שגיאה בניפוי באגים: ' + error.message
        }, { status: 500 });
    }
}
