import { NextRequest, NextResponse } from 'next/server';
import Database from 'better-sqlite3';
import path from 'path';

function getDb() {
    const dbPath = path.join(process.cwd(), 'comprehensive.db');
    return new Database(dbPath);
}

export async function GET(request: NextRequest) {
    const db = getDb();
    try {
        const response: any = { success: true };

        // Check tasks table
        const tasksTableExists = db.prepare(`SELECT name FROM sqlite_master WHERE type='table' AND name='tasks';`).get();
        response.tasks_table = { exists: !!tasksTableExists };
        if (tasksTableExists) {
            response.tasks_table.columns = db.prepare(`PRAGMA table_info(tasks);`).all();
            response.tasks_table.count = (db.prepare(`SELECT COUNT(*) as count FROM tasks;`).get() as { count: number }).count;
            response.tasks_table.sample = db.prepare(`SELECT * FROM tasks LIMIT 1;`).all();
        }

        // Check tasks_categories table
        const categoriesTableExists = db.prepare(`SELECT name FROM sqlite_master WHERE type='table' AND name='tasks_categories';`).get();
        response.tasks_categories_table = { exists: !!categoriesTableExists };
        if (categoriesTableExists) {
            response.tasks_categories_table.columns = db.prepare(`PRAGMA table_info(tasks_categories);`).all();
            response.tasks_categories_table.count = (db.prepare(`SELECT COUNT(*) as count FROM tasks_categories;`).get() as { count: number }).count;
        }

        return NextResponse.json(response);
    } catch (e: unknown) {
        console.error('Debug tasks error:', e);
        return NextResponse.json({ error: 'שגיאה בניפוי באגים: ' + (e as Error).message }, { status: 500 });
    } finally {
        db.close();
    }
}
