import { NextRequest, NextResponse } from 'next/server';
import Database from 'better-sqlite3';
import path from 'path';

const dbPath = path.join(process.cwd(), 'domains.db');

// GET /api/project-tags - רשימת תגיות פרויקטים
export async function GET(request: NextRequest) {
    try {
        const db = new Database(dbPath);

        const query = 'SELECT * FROM project_tags ORDER BY name';
        const tags = db.prepare(query).all();

        db.close();

        return NextResponse.json(tags);

    } catch (error) {
        console.error('Error fetching project tags:', error);
        return NextResponse.json(
            { error: 'שגיאה בטעינת התגיות' },
            { status: 500 }
        );
    }
}

// POST /api/project-tags - יצירת תגית חדשה
export async function POST(request: NextRequest) {
    try {
        const db = new Database(dbPath);
        const body = await request.json();

        const { name, color = '#3B82F6', description } = body;

        if (!name) {
            return NextResponse.json(
                { error: 'שם התגית הוא שדה חובה' },
                { status: 400 }
            );
        }

        const insertQuery = `
      INSERT INTO project_tags (name, color, description)
      VALUES (?, ?, ?)
    `;

        const result = db.prepare(insertQuery).run(name, color, description);

        db.close();

        return NextResponse.json({
            id: result.lastInsertRowid,
            message: 'תגית נוצרה בהצלחה'
        });

    } catch (error) {
        console.error('Error creating project tag:', error);
        return NextResponse.json(
            { error: 'שגיאה ביצירת התגית' },
            { status: 500 }
        );
    }
}
