/**
 * API Route: Clear Demo Notes
 * POST /api/notes/clear-demo - מחיקת פתקי דמו (משאיר רשימות)
 */

import { NextRequest, NextResponse } from 'next/server';
import { getNotesDatabase } from '@/src/lib/notes-db';

export async function POST(request: NextRequest) {
    try {
        const body = await request.json();
        const { deleteNotes = false, deleteLists = false } = body;

        const db = await getNotesDatabase();

        console.log('🗑️ מוחק נתונים...');
        console.log(`   - פתקים: ${deleteNotes ? 'כן' : 'לא'}`);
        console.log(`   - רשימות: ${deleteLists ? 'כן' : 'לא'}`);

        // Delete notes if requested
        if (deleteNotes) {
            await db.run('DELETE FROM notes');
            console.log('✅ נמחקו כל הפתקים');
        }

        // Delete lists if requested
        if (deleteLists) {
            await db.run('DELETE FROM lists');
            console.log('✅ נמחקו כל הרשימות');
        }

        const remainingNotes = await db.get('SELECT COUNT(*) as count FROM notes');
        const remainingLists = await db.get('SELECT COUNT(*) as count FROM lists');

        console.log(`📊 נשארו: ${remainingNotes.count} פתקים, ${remainingLists.count} רשימות`);

        return NextResponse.json({
            success: true,
            message: 'מחיקה הושלמה בהצלחה!',
            stats: {
                notes: remainingNotes.count,
                lists: remainingLists.count
            }
        }, { status: 200 });

    } catch (error: any) {
        console.error('Error clearing data:', error);
        return NextResponse.json(
            { error: error.message },
            { status: 500 }
        );
    }
}

