/**
 * API Route: Debug Events
 * GET /api/events/debug - בדיקת בעיות באירועים
 */

import { NextRequest, NextResponse } from 'next/server';
import Database from 'better-sqlite3';
import path from 'path';

export async function GET(request: NextRequest) {
    try {
        const dbPath = path.join(process.cwd(), 'comprehensive.db');
        const db = new Database(dbPath);

        // Check if events table exists
        const tableExists = db.prepare(`
            SELECT name FROM sqlite_master WHERE type='table' AND name='events'
        `).get();

        if (!tableExists) {
            db.close();
            return NextResponse.json({
                error: 'טבלת events לא קיימת!',
                exists: false,
                fix_url: '/fix-all-tables.html'
            }, { status: 404 });
        }

        // Get table schema
        const schema = db.prepare(`PRAGMA table_info(events)`).all();

        // Get count
        const count = db.prepare('SELECT COUNT(*) as count FROM events').get() as { count: number };

        // Get sample events
        const events = db.prepare('SELECT * FROM events LIMIT 5').all();

        // Check customers table
        const customersExists = db.prepare(`
            SELECT name FROM sqlite_master WHERE type='table' AND name='customers'
        `).get();

        const customersCount = customersExists
            ? (db.prepare('SELECT COUNT(*) as count FROM customers').get() as { count: number })
            : { count: 0 };

        db.close();

        return NextResponse.json({
            success: true,
            events_table: {
                exists: true,
                columns: schema,
                count: count.count,
                sample: events
            },
            customers_table: {
                exists: !!customersExists,
                count: customersCount.count
            }
        });

    } catch (error: any) {
        console.error('Debug error:', error);
        return NextResponse.json({
            error: error.message,
            stack: error.stack
        }, { status: 500 });
    }
}

