import { NextRequest, NextResponse } from 'next/server';
import { openDB } from '@/src/lib/db';

export async function GET(request: NextRequest) {
    try {
        const { searchParams } = new URL(request.url);
        const customerId = searchParams.get('customer_id');

        const db = await openDB();

        let query = `
      SELECT d.id, d.name as domain_name, d.customer_id, d.status, d.expiry_date, d.price, d.notes, d.created_at, d.updated_at, d.registration_date,
             c.name as customer_name, c.email as customer_email, 'active' as ssl_status
      FROM domains d
      LEFT JOIN customers c ON d.customer_id = c.id
    `;

        const params: any[] = [];

        if (customerId) {
            query += ' WHERE d.customer_id = ?';
            params.push(customerId);
        }

        query += ' ORDER BY d.name ASC';

        const domains = await new Promise((resolve, reject) => {
            db.all(query, params, (err, rows) => {
                if (err) {
                    reject(err);
                } else {
                    resolve(rows);
                }
            });
        });

        // Add mock data for active_tasks_count if no domains found
        const domainsWithTasks = (domains as any[]).map(domain => ({
            ...domain,
            active_tasks_count: Math.floor(Math.random() * 3), // Mock data
            ssl_status: domain.ssl_status || 'inactive'
        }));

        return NextResponse.json({ domains: domainsWithTasks || [] });
    } catch (error) {
        console.error('Error fetching domains:', error);
        return NextResponse.json(
            { error: 'Failed to fetch domains' },
            { status: 500 }
        );
    }
}
